/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.views.console;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.views.console.ConsoleDocument;
import com.vectrace.MercurialEclipse.views.console.HgConsoleHolder;
import com.vectrace.MercurialEclipse.views.console.Messages;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class HgConsole
extends MessageConsole {
    private Color commandColor;
    private Color messageColor;
    private Color errorColor;
    private static final String HTTP_PATTERN_STRING = "[hH][tT][tT][pP].*[@]";
    private static final String HTTPS_PATTERN_STRING = "[hH][tT][tT][pP][sS].*[@]";
    private static final String SSH_PATTERN_STRING = "[sS][sS][hH].*[@]";
    private static final String SVN_PATTERN_STRING = "[sS][vV][nN].*[@]";
    private static final Pattern HTTP_PATTERN = Pattern.compile("[hH][tT][tT][pP].*[@]");
    private static final Pattern HTTPS_PATTERN = Pattern.compile("[hH][tT][tT][pP][sS].*[@]");
    private static final Pattern SSH_PATTERN = Pattern.compile("[sS][sS][hH].*[@]");
    private static final Pattern SVN_PATTERN = Pattern.compile("[sS][vV][nN].*[@]");
    private long commandStarted = 0L;
    private MessageConsoleStream commandStream;
    private MessageConsoleStream messageStream;
    private MessageConsoleStream errorStream;
    private final ConsoleDocument document;
    private final DateFormat TIME_FORMAT = new SimpleDateFormat("m:ss.SSS");
    private boolean visible;
    private boolean initialized;
    private boolean debugTimeEnabled;
    private boolean debugEnabled;
    private static final String NESTING = "   ";

    public HgConsole() {
        super("Mercurial Console", MercurialEclipsePlugin.getImageDescriptor("mercurialeclipse.png"));
        this.document = new ConsoleDocument();
    }

    protected void init() {
        super.init();
        IPreferenceStore store = MercurialEclipsePlugin.getDefault().getPreferenceStore();
        this.debugTimeEnabled = store.getBoolean("hg.console.debug.time");
        this.debugEnabled = store.getBoolean("hg.console.debug");
        this.initLimitOutput(store);
        this.initWrapSetting(store);
        this.initializeStreams();
        this.dump();
    }

    private void initWrapSetting(IPreferenceStore store) {
        if (store.getBoolean("hg.console.wrap")) {
            this.setConsoleWidth(store.getInt("hg.console.width"));
        } else {
            this.setConsoleWidth(-1);
        }
    }

    private void initLimitOutput(IPreferenceStore store) {
        if (store.getBoolean("hg.console.limitOutput")) {
            int highWaterMark = store.getInt("hg.console.highWaterMark");
            if (highWaterMark < 1000) {
                highWaterMark = 1000;
            }
            this.setWaterMarks(0, highWaterMark);
        } else {
            this.setWaterMarks(0, 1000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeStreams() {
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            if (this.initialized) {
                return;
            }
            this.commandStream = this.newMessageStream();
            this.errorStream = this.newMessageStream();
            this.messageStream = this.newMessageStream();
            IPreferenceStore store = MercurialEclipsePlugin.getDefault().getPreferenceStore();
            this.commandColor = this.createColor(store, "hg.console.command_color");
            this.commandStream.setColor(this.commandColor);
            this.messageColor = this.createColor(store, "hg.console.message_color");
            this.messageStream.setColor(this.messageColor);
            this.errorColor = this.createColor(store, "hg.console.error_color");
            this.errorStream.setColor(this.errorColor);
            this.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump() {
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            this.visible = true;
            ConsoleDocument.ConsoleLine[] lines = this.document.getLines();
            int i = 0;
            while (i < lines.length) {
                ConsoleDocument.ConsoleLine line = lines[i];
                this.appendLine(line.type, line.line);
                ++i;
            }
            this.document.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendLine(int type, String line) {
        HgConsoleHolder.getInstance().showConsole(false);
        String myLine = line == null ? "" : line;
        myLine = HTTP_PATTERN.matcher(myLine).replaceAll("http://***@");
        if (myLine.equals(line)) {
            myLine = HTTPS_PATTERN.matcher(line).replaceAll("https://***@");
        }
        if (myLine.equals(line)) {
            myLine = SSH_PATTERN.matcher(line).replaceAll("ssh://***@");
        }
        if (myLine.equals(line)) {
            myLine = SVN_PATTERN.matcher(line).replaceAll("svn://***@");
        }
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            if (this.visible) {
                switch (type) {
                    case 0: {
                        this.commandStream.println(myLine);
                        break;
                    }
                    case 1: {
                        this.messageStream.println(myLine);
                        break;
                    }
                    case 2: {
                        this.errorStream.println(myLine);
                    }
                }
            } else {
                this.document.appendConsoleLine(type, myLine);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            this.visible = false;
        }
    }

    public void shutdown() {
        super.dispose();
        if (this.commandColor != null) {
            this.commandColor.dispose();
        }
        if (this.messageColor != null) {
            this.messageColor.dispose();
        }
        if (this.errorColor != null) {
            this.errorColor.dispose();
        }
    }

    public void commandInvoked(String line) {
        this.commandStarted = System.currentTimeMillis();
        this.appendLine(0, line);
    }

    public void messageLineReceived(String line, IStatus status) {
        this.appendLine(1, line);
    }

    public void errorLineReceived(String line, IStatus status) {
        this.appendLine(2, line);
    }

    private boolean isDebugTimeEnabled() {
        return this.debugTimeEnabled;
    }

    public void commandCompleted(IStatus status, Throwable exception) {
        String time = this.getTimeString();
        if (status != null) {
            if (status.getSeverity() == 4) {
                this.printStatus(status, time, false);
            } else if (this.debugEnabled) {
                this.printStatus(status, time, true);
            } else if (this.isDebugTimeEnabled()) {
                this.appendLine(1, time);
            }
        } else if (exception != null) {
            String statusText = exception instanceof OperationCanceledException ? String.valueOf(Messages.getString("HgConsole.aborted1")) + time + Messages.getString("HgConsole.aborted2") : time;
            this.appendLine(0, statusText);
            if (exception instanceof CoreException) {
                this.outputStatus(((CoreException)exception).getStatus(), true, 1);
            }
        } else if (this.isDebugTimeEnabled()) {
            this.appendLine(1, time);
        }
    }

    private void printStatus(IStatus status, String time, boolean includeRoot) {
        String statusText = status.getMessage();
        if (time.length() > 0) {
            statusText = String.valueOf(statusText) + "(" + time + ")";
        }
        int kind = status.getSeverity() == 4 ? 2 : 1;
        this.appendLine(kind, statusText);
        this.outputStatus(status, includeRoot, includeRoot ? 0 : 1);
    }

    private String getTimeString() {
        String time;
        if (!this.isDebugTimeEnabled()) {
            return "";
        }
        long commandRuntime = System.currentTimeMillis() - this.commandStarted;
        try {
            time = String.valueOf(Messages.getString("HgConsole.doneIn")) + this.TIME_FORMAT.format(new Date(commandRuntime)) + Messages.getString("HgConsole.minutes");
        }
        catch (RuntimeException e) {
            MercurialEclipsePlugin.logError(e);
            time = "";
        }
        return time;
    }

    private void outputStatus(IStatus status, boolean includeParent, int nestingLevel) {
        Throwable t;
        int myNestingLevel = nestingLevel;
        if (includeParent && !status.isOK()) {
            this.outputStatusMessage(status, nestingLevel);
            ++myNestingLevel;
        }
        if ((t = status.getException()) instanceof CoreException) {
            this.outputStatus(((CoreException)t).getStatus(), true, myNestingLevel);
        }
        IStatus[] children = status.getChildren();
        int i = 0;
        while (i < children.length) {
            this.outputStatus(children[i], true, myNestingLevel);
            ++i;
        }
    }

    private void outputStatusMessage(IStatus status, int nesting) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < nesting) {
            buffer.append(NESTING);
            ++i;
        }
        buffer.append(this.messageLineForStatus(status));
        this.appendLine(0, buffer.toString());
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property == null || !property.startsWith("hg.console.")) {
            return;
        }
        IPreferenceStore store = MercurialEclipsePlugin.getDefault().getPreferenceStore();
        if (this.visible) {
            if (property.equals("hg.console.command_color")) {
                Color newColor = this.createColor(store, "hg.console.command_color");
                this.commandStream.setColor(newColor);
                this.commandColor.dispose();
                this.commandColor = newColor;
            } else if (property.equals("hg.console.message_color")) {
                Color newColor = this.createColor(store, "hg.console.message_color");
                this.messageStream.setColor(newColor);
                this.messageColor.dispose();
                this.messageColor = newColor;
            } else if (property.equals("hg.console.error_color")) {
                Color newColor = this.createColor(store, "hg.console.error_color");
                this.errorStream.setColor(newColor);
                this.errorColor.dispose();
                this.errorColor = newColor;
            } else if (property.equals("hg.console.font")) {
                this.setFont(((FontRegistry)event.getSource()).get("hg.console.font"));
            }
        }
        if (property.equals("hg.console.limitOutput")) {
            this.initLimitOutput(store);
        } else if (property.equals("hg.console.wrap")) {
            this.initWrapSetting(store);
        } else if (property.equals("hg.console.debug.time")) {
            this.debugTimeEnabled = store.getBoolean("hg.console.debug.time");
        } else if (property.equals("hg.console.debug")) {
            this.debugEnabled = store.getBoolean("hg.console.debug");
        }
    }

    private String messageLineForStatus(IStatus status) {
        if (status.getSeverity() == 4) {
            return String.valueOf(Messages.getString("HgConsole.error")) + status.getMessage();
        }
        if (status.getSeverity() == 2) {
            return String.valueOf(Messages.getString("HgConsole.warning")) + status.getMessage();
        }
        if (status.getSeverity() == 1) {
            return String.valueOf(Messages.getString("HgConsole.info")) + status.getMessage();
        }
        return status.getMessage();
    }

    private Color createColor(IPreferenceStore store, String preference) {
        Display display = MercurialEclipsePlugin.getStandardDisplay();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)preference);
        return new Color((Device)display, rgb);
    }
}

