/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.utils;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IniFile {
    private final Map<String, Map<String, String>> sections = new HashMap<String, Map<String, String>>();

    public IniFile() {
    }

    public IniFile(String filename) throws FileNotFoundException {
        this();
        this.load(filename);
    }

    public IniFile(URL url) throws IOException {
        this();
        InputStream in = url.openStream();
        try {
            this.load(in);
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
    }

    public void setKeyValue(String section, String key, String value) {
        Map<String, String> section2 = this.getSection(section);
        if (section2 != null) {
            section2.put(key.toLowerCase(), value);
        }
    }

    public Map<String, Map<String, String>> getSections() {
        return this.sections;
    }

    public Map<String, String> getSection(String section) {
        return this.sections.get(section.toLowerCase());
    }

    public boolean isNullOrEmpty(String section, String key) {
        String value = this.getKeyValue(section, key);
        return value == null || value.length() == 0;
    }

    public String getKeyValue(String section, String key) {
        Map<String, String> section2 = this.getSection(section);
        if (section2 != null) {
            return section2.get(key.toLowerCase());
        }
        return null;
    }

    public int getKeyIntValue(String section, String key) {
        return this.getKeyIntValue(section, key, 0);
    }

    public int getKeyIntValue(String section, String key, int defaultValue) {
        String value = this.getKeyValue(section, key.toLowerCase());
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public void load(String filename) throws FileNotFoundException {
        FileInputStream in = new FileInputStream(filename);
        try {
            this.load(in);
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
    }

    public void save(String filename) throws IOException {
        FileOutputStream out = new FileOutputStream(filename);
        try {
            this.save(out);
        }
        catch (Throwable throwable) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            out.close();
        }
        catch (IOException iOException) {}
    }

    private void load(InputStream in) {
        try {
            String read;
            BufferedReader input = new BufferedReader(new InputStreamReader(in));
            Map<String, String> section = null;
            while ((read = input.readLine()) != null) {
                if (read.startsWith(";") || read.startsWith("#")) continue;
                if (read.startsWith("[")) {
                    String section_name = read.substring(1, read.indexOf("]")).toLowerCase();
                    section = this.sections.get(section_name);
                    if (section != null) continue;
                    section = new HashMap<String, String>();
                    this.sections.put(section_name, section);
                    continue;
                }
                if (read.indexOf("=") == -1 || section == null) continue;
                String key = read.substring(0, read.indexOf("=")).trim().toLowerCase();
                String value = read.substring(read.indexOf("=") + 1).trim();
                section.put(key, value);
            }
        }
        catch (IOException e) {
            MercurialEclipsePlugin.logError(e);
        }
    }

    private void save(OutputStream out) {
        try {
            PrintWriter output = new PrintWriter(out);
            for (String section : this.sections.keySet()) {
                output.println("[" + section + "]");
                for (Map.Entry<String, String> entry : this.getSection(section).entrySet()) {
                    output.println(String.valueOf(entry.getKey()) + "=" + entry.getValue());
                }
            }
            output.flush();
            output.close();
            out.flush();
            out.close();
        }
        catch (IOException e) {
            MercurialEclipsePlugin.logError(e);
        }
    }

    public void addSection(String section) {
        this.sections.put(section.toLowerCase(), new HashMap());
    }

    public void removeSection(String section) {
    }

    public static void main(String[] args) throws Exception {
        new IniFile().load(new FileInputStream(args[0]));
    }
}

