/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.utils;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.history.MercurialRevision;
import com.vectrace.MercurialEclipse.team.cache.LocalChangesetCache;
import com.vectrace.MercurialEclipse.utils.HistoryPainterEdge;
import com.vectrace.MercurialEclipse.utils.HistoryPainterRevision;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryPainter {
    private static final int[] colors = new int[]{3, 10, 11, 6, 8, 13, 12, 5, 4, 9, 14};
    private HistoryPainterRevision roof;
    private final SortedSet<HistoryPainterRevision> revisions = new TreeSet<HistoryPainterRevision>();
    private final SortedSet<HistoryPainterEdge> startedEdges = new TreeSet<HistoryPainterEdge>();
    private List<HistoryPainterRevision> searchList;

    public HistoryPainter(IResource resource) {
        try {
            LocalChangesetCache.getInstance().refreshAllLocalRevisions((IResource)resource.getProject(), false);
            this.roof = new HistoryPainterRevision(resource, LocalChangesetCache.getInstance().getNewestLocalChangeSet(resource));
            this.revisions.clear();
            this.startedEdges.clear();
            this.revisions.add(this.roof);
            this.revisions.addAll(this.loadRevisions(this.roof));
            this.searchList = new ArrayList<HistoryPainterRevision>(this.revisions);
            this.determineLayout();
        }
        catch (HgException e) {
            MercurialEclipsePlugin.logError((Throwable)((Object)e));
        }
    }

    private void determineLayout() {
        int lane = 1;
        for (HistoryPainterRevision rev : this.revisions) {
            lane = Math.max(1, rev.getLane());
            rev.setLane(lane);
            for (HistoryPainterEdge edge : new TreeSet<HistoryPainterEdge>(this.startedEdges)) {
                if (!edge.getStop().equals(rev)) continue;
                this.startedEdges.remove(edge);
            }
            int parCount = 0;
            while (parCount < rev.getParents().size()) {
                HistoryPainterRevision parent = rev.getParents().get(parCount);
                HistoryPainterEdge edge = new HistoryPainterEdge(rev, parent, 0);
                this.startedEdges.add(edge);
                int parentLane = lane + parCount;
                if (parCount > 0) {
                    parentLane = this.startedEdges.size();
                }
                parent.setLane(parentLane);
                ++parCount;
            }
            rev.setLanes(Math.max(lane, this.startedEdges.size()));
        }
    }

    private SortedSet<HistoryPainterRevision> loadRevisions(HistoryPainterRevision hpr) {
        TreeSet<HistoryPainterRevision> parentRevisions = new TreeSet<HistoryPainterRevision>();
        for (HistoryPainterRevision parent : hpr.getParents()) {
            parentRevisions.add(parent);
            parentRevisions.addAll(this.loadRevisions(parent));
        }
        return parentRevisions;
    }

    public void paint(Event e, int columnIndex) {
        if (e.type != 42 || e.index != columnIndex || e.item == null || e.item.getData() == null || !(e.item.getData() instanceof MercurialRevision)) {
            return;
        }
        MercurialRevision mrev = (MercurialRevision)((Object)e.item.getData());
        int itemHeight = e.height;
        int pad = 8;
        int x = e.x + pad;
        int y = e.y;
        GC gc = e.gc;
        gc.setAntialias(1);
        gc.setLineWidth(2);
        int branchOffsetY = itemHeight / 3;
        int startX = x;
        int startY = y;
        int endY = startY + itemHeight;
        HistoryPainterRevision key = new HistoryPainterRevision();
        key.setResource(mrev.getResource());
        key.setChangeSet(mrev.getChangeSet());
        int index = Collections.binarySearch(this.searchList, key);
        HistoryPainterRevision rev = this.searchList.get(index);
        int currLane = 0;
        while (currLane < rev.getLanes()) {
            gc.setForeground(Display.getCurrent().getSystemColor(colors[currLane % 11]));
            startX = this.getStartX(pad, x, currLane);
            gc.drawLine(startX, startY, startX, endY - branchOffsetY);
            if (rev.getLane() == currLane + 1) {
                this.drawCircle(pad, gc, startX, startY);
                this.drawBranch(rev, pad, gc, branchOffsetY, startX, endY);
            }
            if (rev.getParents().size() > 0) {
                gc.drawLine(startX, endY - branchOffsetY, startX, endY);
            }
            ++currLane;
        }
        e.gc.dispose();
    }

    private int getStartX(int pad, int x, int currLane) {
        int startX = x + currLane * pad;
        return startX;
    }

    private void drawCircle(int pad, GC gc, int startX, int startY) {
        gc.drawArc(startX - pad / 2, startY + pad / 2, pad, pad, 0, 360);
        gc.fillArc(startX - pad / 2, startY + pad / 2, pad, pad, 0, 360);
    }

    private void drawBranch(HistoryPainterRevision rev, int pad, GC gc, int arcOffsetY, int startX, int endY) {
        for (HistoryPainterRevision parent : rev.getParents()) {
            int circleWidth = pad * Math.abs(rev.getLane() - parent.getLane());
            if (rev.getLane() < parent.getLane()) {
                gc.drawLine(startX, endY - arcOffsetY, startX + circleWidth, endY);
                continue;
            }
            if (rev.getLane() <= parent.getLane()) continue;
            gc.drawLine(startX - circleWidth, endY, startX, endY - arcOffsetY);
        }
    }

    public HistoryPainterRevision getRoof() {
        return this.roof;
    }

    public void setRoof(HistoryPainterRevision roof) {
        this.roof = roof;
    }
}

