/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.ui;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UntrackedResourcesFilter
extends ViewerFilter {
    private final Map<IProject, Set<IPath>> untrackedFiles;
    private final Map<IProject, Set<IPath>> untrackedFolders;

    public UntrackedResourcesFilter(Map<IProject, Set<IPath>> untrackedFiles, Map<IProject, Set<IPath>> untrackedFolders) {
        this.untrackedFiles = untrackedFiles;
        this.untrackedFolders = untrackedFolders;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        IResource resource = (IResource)element;
        IProject project = resource.getProject();
        String path = resource.getProjectRelativePath().toOSString();
        if (resource.getType() == 1) {
            Set<IPath> set = this.untrackedFiles.get(project);
            return this.isSubPath(path, set);
        }
        if (resource.getType() == 2) {
            Set<IPath> set = this.untrackedFolders.get(project);
            return this.isSubPath(path, set);
        }
        return true;
    }

    private boolean isSubPath(String path, Set<IPath> set) {
        for (IPath setPath : set) {
            String setPathString = setPath.toOSString();
            if (!setPathString.endsWith(path)) continue;
            return true;
        }
        return false;
    }
}

