/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.ui;

import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.model.Tag;
import com.vectrace.MercurialEclipse.team.cache.LocalChangesetCache;
import com.vectrace.MercurialEclipse.ui.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TagTable
extends Composite {
    private static final Font PARENT_FONT = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.dialogfont");
    private final Table table;
    private int[] parents;
    private boolean showTip = true;
    private final IProject project;

    public TagTable(Composite parent, IProject project) {
        super(parent, 0);
        this.project = project;
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData());
        this.table = new Table((Composite)this, 68356);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        GridData data = new GridData(4, 4, true, true);
        this.table.setLayoutData((Object)data);
        String[] titles = new String[]{Messages.getString("TagTable.column.rev"), Messages.getString("TagTable.column.global"), Messages.getString("TagTable.column.tag"), Messages.getString("TagTable.column.local"), Messages.getString("ChangesetTable.column.summary")};
        int[] widths = new int[]{50, 150, 200, 70, 300};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(this.table, 0);
            column.setText(titles[i]);
            column.setWidth(widths[i]);
            ++i;
        }
    }

    public void hideTip() {
        this.showTip = false;
    }

    public void highlightParents(int[] newParents) {
        this.parents = newParents;
    }

    public void setTags(Tag[] tags) {
        this.table.removeAll();
        LocalChangesetCache cache = LocalChangesetCache.getInstance();
        Tag[] tagArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            Tag tag = tagArray[n2];
            if (this.showTip || !"tip".equals(tag.getName())) {
                TableItem row = new TableItem(this.table, 0);
                if (this.parents != null && this.isParent(tag.getRevision())) {
                    row.setFont(PARENT_FONT);
                }
                row.setText(0, Integer.toString(tag.getRevision()));
                row.setText(1, tag.getGlobalId());
                row.setText(2, tag.getName());
                row.setText(3, tag.isLocal() ? Messages.getString("TagTable.stateLocal") : Messages.getString("TagTable.stateGlobal"));
                ChangeSet changeSet = cache.getChangeset(this.project, String.valueOf(tag.getRevision()) + ":" + tag.getGlobalId());
                if (changeSet != null) {
                    row.setText(4, changeSet.getSummary());
                }
                row.setData((Object)tag);
            }
            ++n2;
        }
    }

    public Tag getSelection() {
        TableItem[] selection = this.table.getSelection();
        if (selection.length == 0) {
            return null;
        }
        return (Tag)selection[0].getData();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.table.addSelectionListener(listener);
    }

    private boolean isParent(int r) {
        switch (this.parents.length) {
            case 2: {
                if (r == this.parents[1]) {
                    return true;
                }
            }
            case 1: {
                if (r != this.parents[0]) break;
                return true;
            }
        }
        return false;
    }
}

