/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.ui;

import com.vectrace.MercurialEclipse.model.Patch;
import com.vectrace.MercurialEclipse.ui.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatchTable
extends Composite {
    private static Color APPLIED_COLOR;
    private static final Font APPLIED_FONT;
    private Table table;

    static {
        APPLIED_FONT = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.dialogfont");
    }

    public PatchTable(Composite parent) {
        super(parent, 0);
        if (APPLIED_COLOR == null) {
            APPLIED_COLOR = new Color((Device)this.getDisplay(), new RGB(225, 255, 172));
        }
        this.setLayout((Layout)new GridLayout(1, false));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.table = new Table((Composite)this, 68354);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        GridData data = new GridData(4, 4, true, true);
        this.table.setLayoutData((Object)data);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        String[] titles = new String[]{Messages.getString("PatchTable.0"), Messages.getString("PatchTable.applied"), Messages.getString("PatchTable.name"), Messages.getString("PatchTable.summary")};
        int[] widths = new int[]{20, 100, 150, 150};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(this.table, 0);
            column.setText(titles[i]);
            column.setWidth(widths[i]);
            ++i;
        }
    }

    public void setPatches(Patch[] patches) {
        this.table.removeAll();
        Patch[] patchArray = patches;
        int n = patches.length;
        int n2 = 0;
        while (n2 < n) {
            Patch patch = patchArray[n2];
            TableItem row = new TableItem(this.table, 0);
            if (patch.isApplied()) {
                row.setFont(APPLIED_FONT);
                row.setBackground(1, APPLIED_COLOR);
            }
            row.setText(0, patch.getIndex());
            row.setText(1, patch.isApplied() ? Messages.getString("PatchTable.statusApplied") : Messages.getString("PatchTable.statusUnapplied"));
            row.setText(2, patch.getName());
            row.setText(3, patch.getSummary());
            row.setData((Object)patch);
            ++n2;
        }
    }

    public Patch getSelection() {
        List<Patch> list = this.getSelections();
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public List<Patch> getSelections() {
        TableItem[] selection = this.table.getSelection();
        if (selection.length == 0) {
            return null;
        }
        ArrayList<Patch> list = new ArrayList<Patch>();
        TableItem[] tableItemArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            Patch p = (Patch)tableItem.getData();
            list.add(p);
            ++n2;
        }
        return list;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.table.addSelectionListener(listener);
    }

    public void dispose() {
        super.dispose();
        APPLIED_COLOR.dispose();
    }
}

