/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team.cache;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.SafeWorkspaceJob;
import com.vectrace.MercurialEclipse.commands.HgClients;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.operations.InitOperation;
import com.vectrace.MercurialEclipse.preferences.MercurialPreferenceConstants;
import com.vectrace.MercurialEclipse.team.MercurialTeamProvider;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import com.vectrace.MercurialEclipse.team.cache.Messages;
import com.vectrace.MercurialEclipse.utils.ResourceUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ResourceDeltaVisitor
implements IResourceDeltaVisitor {
    private final Map<IProject, Set<IResource>> removed;
    private final Map<IProject, Set<IResource>> changed;
    private final Map<IProject, Set<IResource>> added;
    private final boolean completeStatus;
    private final boolean autoShare;
    private final MercurialStatusCache cache;
    private int resourcesCount;

    ResourceDeltaVisitor(Map<IProject, Set<IResource>> removed, Map<IProject, Set<IResource>> changed, Map<IProject, Set<IResource>> added) {
        this.removed = removed;
        this.changed = changed;
        this.added = added;
        this.cache = MercurialStatusCache.getInstance();
        this.completeStatus = Boolean.valueOf(HgClients.getPreference("hg.performance.getStatusForCompleteRepository", "false"));
        this.autoShare = Boolean.valueOf(HgClients.getPreference(MercurialPreferenceConstants.PREF_AUTO_SHARE_PROJECTS, "false"));
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        boolean projectOpenOrClosed;
        IResource res = delta.getResource();
        if (res.getType() == 8) {
            return true;
        }
        IProject project = res.getProject();
        boolean bl = projectOpenOrClosed = delta.getFlags() == 16384;
        if (this.autoShare && projectOpenOrClosed && project.isAccessible() && RepositoryProvider.getProvider((IProject)project) == null) {
            this.autoshareProject(project);
            return false;
        }
        if (!MercurialUtilities.isPossiblySupervised(res)) {
            return false;
        }
        if (res == project && projectOpenOrClosed || this.isCompleteStatusRequested()) {
            this.addResource(this.changed, project, (IResource)project);
            return false;
        }
        if (res.getType() == 1) {
            IProject resource = this.isCompleteStatusRequested() ? project : res;
            switch (delta.getKind()) {
                case 1: {
                    this.addResource(this.added, project, (IResource)resource);
                    if (!this.isCompleteStatusRequested()) break;
                    return false;
                }
                case 4: {
                    if (!this.hasChangedBits(delta) || !this.cache.isSupervised((IResource)project, ResourceUtils.getPath(res))) break;
                    this.addResource(this.changed, project, (IResource)resource);
                    if (!this.isCompleteStatusRequested()) break;
                    return false;
                }
                case 2: {
                    if (this.cache.isSupervised((IResource)project, ResourceUtils.getPath(res))) {
                        this.addResource(this.removed, project, (IResource)resource);
                        if (!this.isCompleteStatusRequested()) break;
                        return false;
                    }
                    if ((res = res.getParent()) == null || !this.cache.isSupervised((IResource)project, ResourceUtils.getPath(res))) break;
                    resource = this.isCompleteStatusRequested() ? project : res;
                    this.addResource(this.changed, project, (IResource)resource);
                    if (!this.isCompleteStatusRequested()) break;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isCompleteStatusRequested() {
        return this.completeStatus || this.resourcesCount > 50;
    }

    private void addResource(Map<IProject, Set<IResource>> map, IProject project, IResource res) {
        Set<IResource> set = map.get(project);
        if (set == null) {
            set = new HashSet<IResource>();
            map.put(project, set);
        }
        set.add(res);
        ++this.resourcesCount;
    }

    private boolean hasChangedBits(IResourceDelta delta) {
        return (delta.getFlags() & 0x4D100) != 0;
    }

    private void autoshareProject(final IProject project) {
        HgRoot hgRoot;
        try {
            hgRoot = MercurialTeamProvider.getHgRoot((IResource)project);
            MercurialEclipsePlugin.logInfo("Autosharing " + project.getName() + ". Detected repository location: " + hgRoot.getAbsolutePath(), null);
        }
        catch (HgException e) {
            MercurialEclipsePlugin.logInfo("Autosharing failed: " + e.getLocalizedMessage(), (Throwable)((Object)e));
            return;
        }
        final IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        new SafeWorkspaceJob(NLS.bind((String)Messages.mercurialStatusCache_autoshare, (Object)project.getName())){

            protected IStatus runSafe(IProgressMonitor monitor) {
                try {
                    new InitOperation((IRunnableContext)activeWorkbenchWindow, project, hgRoot, hgRoot.getAbsolutePath()).run(monitor);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return super.runSafe(monitor);
            }
        }.schedule();
    }
}

