/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team.cache;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.SafeWorkspaceJob;
import com.vectrace.MercurialEclipse.commands.HgClients;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.team.cache.IncomingChangesetCache;
import com.vectrace.MercurialEclipse.team.cache.LocalChangesetCache;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import com.vectrace.MercurialEclipse.team.cache.Messages;
import com.vectrace.MercurialEclipse.team.cache.OutgoingChangesetCache;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;

public final class RefreshJob
extends SafeWorkspaceJob {
    public static final int LOCAL = 1;
    public static final int INCOMING = 2;
    public static final int OUTGOING = 4;
    public static final int LOCAL_AND_INCOMING = 3;
    public static final int LOCAL_AND_OUTGOING = 5;
    public static final int ALL = 7;
    private static final MercurialStatusCache mercurialStatusCache = MercurialStatusCache.getInstance();
    private final IProject project;
    private final boolean withFiles;
    private final int type;

    public RefreshJob(String name, IProject project, int type) {
        super(name);
        this.project = project;
        this.withFiles = RefreshJob.getWithFilesProperty();
        this.type = type;
    }

    public RefreshJob(String name, IProject project) {
        this(name, project, 7);
    }

    private static boolean getWithFilesProperty() {
        return Boolean.valueOf(HgClients.getPreference("hg.performance.fileShowsChangeset", "false"));
    }

    protected IStatus runSafe(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (MercurialEclipsePlugin.getDefault().isDebugging()) {
            System.out.println("Refresh Job for: " + this.project);
        }
        try {
            if ((this.type & 1) != 0) {
                monitor.subTask(Messages.refreshJob_LoadingLocalRevisions);
                LocalChangesetCache.getInstance().refreshAllLocalRevisions((IResource)this.project, true, this.withFiles);
                monitor.worked(1);
                monitor.subTask(Messages.refreshJob_UpdatingStatusAndVersionCache);
                mercurialStatusCache.clear(this.project, false);
                mercurialStatusCache.refreshStatus((IResource)this.project, monitor);
                monitor.worked(1);
            }
            if ((this.type & 4) == 0 && (this.type & 2) == 0) {
                return super.runSafe(monitor);
            }
            Set<HgRepositoryLocation> repoLocations = MercurialEclipsePlugin.getRepoManager().getAllProjectRepoLocations(this.project);
            for (HgRepositoryLocation repositoryLocation : repoLocations) {
                if ((this.type & 2) != 0) {
                    monitor.subTask(String.valueOf(Messages.refreshJob_LoadingIncomingRevisions) + repositoryLocation);
                    IncomingChangesetCache.getInstance().clear(repositoryLocation, this.project, true);
                    monitor.worked(1);
                }
                if ((this.type & 4) == 0) continue;
                monitor.subTask(String.valueOf(Messages.refreshJob_LoadingOutgoingRevisionsFor) + repositoryLocation);
                OutgoingChangesetCache.getInstance().clear(repositoryLocation, this.project, true);
                monitor.worked(1);
            }
        }
        catch (HgException e) {
            MercurialEclipsePlugin.logError((Throwable)((Object)e));
        }
        return super.runSafe(monitor);
    }
}

