/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team.cache;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.commands.HgResolveClient;
import com.vectrace.MercurialEclipse.commands.HgStatusClient;
import com.vectrace.MercurialEclipse.commands.extensions.HgIMergeClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.FlaggedAdaptable;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.team.ResourceProperties;
import com.vectrace.MercurialEclipse.team.cache.AbstractCache;
import com.vectrace.MercurialEclipse.team.cache.Bits;
import com.vectrace.MercurialEclipse.team.cache.Messages;
import com.vectrace.MercurialEclipse.team.cache.ResourceDeltaVisitor;
import com.vectrace.MercurialEclipse.utils.ResourceUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.Team;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MercurialStatusCache
extends AbstractCache
implements IResourceChangeListener {
    private static final int STATUS_BATCH_SIZE = 10;
    static final int NUM_CHANGED_FOR_COMPLETE_STATUS = 50;
    public static final int BIT_IGNORE = 0;
    public static final int BIT_CLEAN = 2;
    public static final int BIT_MISSING = 4;
    public static final int BIT_REMOVED = 8;
    public static final int BIT_UNKNOWN = 16;
    public static final int BIT_ADDED = 32;
    public static final int BIT_MODIFIED = 64;
    public static final int BIT_IMPOSSIBLE = 128;
    public static final int BIT_CONFLICT = 256;
    public static final Integer _IGNORE = 0;
    public static final Integer _CLEAN = 2;
    public static final Integer _MISSING = 4;
    public static final Integer _REMOVED = 8;
    public static final Integer _UNKNOWN = 16;
    public static final Integer _ADDED = 32;
    public static final Integer _MODIFIED = 64;
    public static final Integer _IMPOSSIBLE = 128;
    public static final Integer _CONFLICT = 256;
    public static final char CHAR_IGNORED = 'I';
    public static final char CHAR_CLEAN = 'C';
    public static final char CHAR_MISSING = '!';
    public static final char CHAR_REMOVED = 'R';
    public static final char CHAR_UNKNOWN = '?';
    public static final char CHAR_ADDED = 'A';
    public static final char CHAR_MODIFIED = 'M';
    public static final char CHAR_UNRESOLVED = 'U';
    public static final char CHAR_RESOLVED = 'R';
    private static final int IGNORED_MASK = 62;
    private static final int MODIFIED_MASK = 124;
    private static final int DIR_SUPERVISED_MASK = 366;
    private static final int DIR_NOT_ADDED_MASK = 334;
    protected static final int MASK_CHANGED = 315648;
    protected static final int MASK_DELTA = 325891;
    private final ConcurrentHashMap<IPath, Integer> statusMap = new ConcurrentHashMap();
    private final BitMap bitMap;
    private final Object statusUpdateLock = new byte[0];
    private final ConcurrentHashMap<IProject, HgRoot> knownStatus = new ConcurrentHashMap();
    private boolean computeDeepStatus;
    private boolean completeStatus;
    private int statusBatchSize;
    private static final Set<IResource> EMPTY_SET = new HashSet<IResource>();
    Pattern NEWLINE = Pattern.compile("\n");

    private MercurialStatusCache() {
        this.bitMap = new BitMap();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public static final MercurialStatusCache getInstance() {
        return MercurialStatusCacheHolder.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStatusKnown(IProject project) {
        Object object = this.statusUpdateLock;
        synchronized (object) {
            return this.knownStatus.containsKey(project);
        }
    }

    public Integer getStatus(IResource resource) {
        return this.statusMap.get(resource.getLocation());
    }

    public boolean isSupervised(IResource resource) {
        return this.isSupervised(resource, resource.getLocation());
    }

    public boolean isSupervised(IResource resource, IPath path) {
        Assert.isNotNull((Object)resource);
        Assert.isNotNull((Object)path);
        Integer statusInt = this.statusMap.get(path);
        if (statusInt == null) {
            return false;
        }
        IProject project = resource.getProject();
        if (path.equals((Object)project.getLocation())) {
            return project.isAccessible() && RepositoryProvider.getProvider((IProject)project, (String)"com.vectrace.MercurialEclipse.team.MercurialTeamProvider") != null;
        }
        int status = statusInt;
        int highestBit = Bits.highestBit(status);
        switch (highestBit) {
            case 0: 
            case 16: {
                if (resource.getType() != 1 && highestBit != 0) {
                    if (Team.isIgnoredHint((IResource)resource)) {
                        return false;
                    }
                    return Bits.contains(status, 366);
                }
                return false;
            }
        }
        return true;
    }

    public boolean isAdded(IPath path) {
        Assert.isNotNull((Object)path);
        Integer statusInt = this.statusMap.get(path);
        if (statusInt == null) {
            return false;
        }
        int status = statusInt;
        if (Bits.highestBit(status) == 32) {
            File fileSystemResource = path.toFile();
            if (fileSystemResource.isDirectory()) {
                return Bits.contains(status, 334);
            }
            return true;
        }
        return false;
    }

    public boolean isRemoved(IResource resource) {
        Assert.isNotNull((Object)resource);
        Integer status = this.getStatus(resource);
        if (status == null) {
            return false;
        }
        return Bits.contains(status, 8);
    }

    public boolean isUnknown(IResource resource) {
        Assert.isNotNull((Object)resource);
        Integer status = this.getStatus(resource);
        if (status == null) {
            return false;
        }
        return Bits.contains(status, 16);
    }

    public boolean isClean(IResource resource) {
        Assert.isNotNull((Object)resource);
        Integer status = this.getStatus(resource);
        if (status == null) {
            return false;
        }
        return Bits.contains(status, 2);
    }

    public Set<IResource> getResources(int statusBit, IContainer folder) {
        HashSet<IResource> resources;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (statusBit == 8) {
            Set<IPath> set = this.bitMap.get(8);
            if (set == null || set.isEmpty()) {
                return EMPTY_SET;
            }
            IPath parentPath = ResourceUtils.getPath((IResource)folder);
            resources = new HashSet();
            for (IPath path : set) {
                IFile tmp = root.getFileForLocation(path);
                if (tmp != null) {
                    if (!parentPath.isPrefixOf(path)) continue;
                    resources.add((IResource)tmp);
                    continue;
                }
                IContainer container = root.getContainerForLocation(path);
                if (container == null || !parentPath.isPrefixOf(path)) continue;
                resources.add((IResource)container);
            }
        } else {
            resources = new HashSet<IResource>();
            Set<Map.Entry<IPath, Integer>> entrySet = this.statusMap.entrySet();
            IPath parentPath = ResourceUtils.getPath((IResource)folder);
            for (Map.Entry<IPath, Integer> entry : entrySet) {
                Integer status = entry.getValue();
                if (status == null || !Bits.contains(status, statusBit)) continue;
                IPath path = entry.getKey();
                IFile tmp = root.getFileForLocation(path);
                if (tmp != null) {
                    if (!parentPath.isPrefixOf(path)) continue;
                    resources.add((IResource)tmp);
                    continue;
                }
                IContainer container = root.getContainerForLocation(path);
                if (container == null || !parentPath.isPrefixOf(path)) continue;
                resources.add((IResource)container);
            }
        }
        return resources;
    }

    private static IProgressMonitor checkMonitor(IProgressMonitor monitor) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        return monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshStatus(IResource res, IProgressMonitor monitor) throws HgException {
        Set<IResource> changed;
        Assert.isNotNull((Object)res);
        monitor = MercurialStatusCache.checkMonitor(monitor);
        monitor.subTask(String.valueOf(Messages.mercurialStatusCache_Refreshing) + res.getName());
        IProject project = res.getProject();
        if (!project.isOpen() || !MercurialUtilities.isPossiblySupervised(res)) {
            return;
        }
        HgRoot root = AbstractClient.getHgRoot(res);
        Object object = this.statusUpdateLock;
        synchronized (object) {
            String output = HgStatusClient.getStatusWithoutIgnored(root, res);
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(1);
            if (res instanceof IProject) {
                this.clearProjectCache(project);
            } else {
                this.clearStatusCache(res);
            }
            monitor.worked(1);
            if (monitor.isCanceled()) {
                return;
            }
            if (res instanceof IProject) {
                this.knownStatus.put(project, root);
            }
            changed = this.parseStatus(root, project, output);
        }
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(1);
        try {
            String mergeNode = HgStatusClient.getMergeStatus(res);
            project.setPersistentProperty(ResourceProperties.MERGING, mergeNode);
        }
        catch (CoreException e) {
            throw new HgException(Messages.mercurialStatusCache_FailedToRefreshMergeStatus, e);
        }
        changed.addAll(this.checkForConflict(project));
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(1);
        this.notifyChanged(changed, false);
        monitor.worked(1);
    }

    private Set<IPath> getChildrenFromCache(IContainer folder) {
        HashSet<IPath> children = new HashSet<IPath>();
        IPath parentPath = ResourceUtils.getPath((IResource)folder);
        Set entrySet = this.statusMap.keySet();
        for (IPath path : entrySet) {
            if (path == null || !parentPath.isPrefixOf(path)) continue;
            children.add(path);
        }
        children.remove(parentPath);
        return children;
    }

    private Set<IResource> checkForConflict(IProject project) throws HgException {
        try {
            if (project.getPersistentProperty(ResourceProperties.MERGING) == null) {
                return Collections.emptySet();
            }
        }
        catch (CoreException e) {
            MercurialEclipsePlugin.logError(e);
            return Collections.emptySet();
        }
        List<FlaggedAdaptable> status = HgResolveClient.checkAvailable() ? HgResolveClient.list((IResource)project) : HgIMergeClient.getMergeStatus((IResource)project);
        HashSet<IResource> changed = new HashSet<IResource>();
        Set<IFile> members = this.getLocalMembers((IResource)project);
        for (IFile res : members) {
            if (!this.removeConflict((IResource)res)) continue;
            changed.add((IResource)res);
        }
        if (this.removeConflict((IResource)project)) {
            changed.add((IResource)project);
        }
        for (FlaggedAdaptable flaggedAdaptable : status) {
            IFile file = (IFile)flaggedAdaptable.getAdapter(IFile.class);
            if (flaggedAdaptable.getFlag() != 'U') continue;
            changed.addAll(this.addConflict((IResource)file));
        }
        return changed;
    }

    private Set<IResource> parseStatus(HgRoot root, IProject project, String output) {
        String[] lines;
        long start = System.currentTimeMillis();
        HashSet<IResource> changed = new HashSet<IResource>();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        ArrayList<String> strangeStates = new ArrayList<String>();
        String[] stringArray = lines = this.NEWLINE.split(output);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.length() <= 2) {
                strangeStates.add(line);
            } else {
                int bit = this.getBit(line.charAt(0));
                if (bit == 128) {
                    strangeStates.add(line);
                } else {
                    Path path;
                    String localName = line.substring(2);
                    IResource member = this.convertRepoRelPath(root, project, localName);
                    if (member != null || bit == 8 && (member = workspaceRoot.getFileForLocation((IPath)(path = new Path(new File(root, localName).getAbsolutePath())))) != null && member.getProject().equals((Object)project)) {
                        Integer bitSet;
                        boolean ignoredHint = Team.isIgnoredHint((IResource)member);
                        if (ignoredHint) {
                            bitSet = _IGNORE;
                        } else {
                            bitSet = bit;
                            changed.add(member);
                        }
                        this.setStatus(member.getLocation(), bitSet);
                        changed.addAll(this.setStatusToAncestors(member, bitSet));
                    }
                }
            }
            ++n2;
        }
        if (strangeStates.size() > 0) {
            IStatus[] states = new IStatus[strangeStates.size()];
            int i = 0;
            while (i < states.length) {
                states[i] = MercurialEclipsePlugin.createStatus((String)strangeStates.get(i), 0, 1, null);
                ++i;
            }
            String message = "Strange status received form hg";
            MultiStatus st = new MultiStatus("com.vectrace.MercurialEclipse", 0, states, message, (Throwable)new Exception(message));
            MercurialEclipsePlugin.getDefault().getLog().log((IStatus)st);
        }
        if (this.debug) {
            System.out.println("Parse status took: " + (System.currentTimeMillis() - start));
        }
        return changed;
    }

    private void setStatus(IPath location, Integer status) {
        this.statusMap.put(location, status);
        this.bitMap.put(location, status);
    }

    private Set<IResource> setStatusToAncestors(IResource resource, Integer resourceBitSet) {
        IProject project = resource.getProject();
        HashSet<IResource> ancestors = new HashSet<IResource>();
        boolean computeDeep = this.isComputeDeepStatus();
        boolean complete = this.isCompleteStatus();
        IContainer parent = resource.getParent();
        while (parent != null && parent != project.getParent()) {
            IPath location = parent.getLocation();
            int parentBitSet = 0;
            Integer parentBits = this.statusMap.get(location);
            if (parentBits != null) {
                parentBitSet = parentBits;
            }
            int cloneBitSet = resourceBitSet;
            cloneBitSet = Bits.clear(cloneBitSet, 62);
            boolean intersects = Bits.contains(resourceBitSet, 124);
            cloneBitSet = intersects ? (cloneBitSet |= 0x40) : (cloneBitSet |= 2);
            if (!complete && computeDeep && resource.getType() != 4) {
                if (parent.isAccessible() && !parent.isTeamPrivateMember() && !parent.isDerived()) {
                    MemberStatusVisitor visitor = new MemberStatusVisitor(parent, cloneBitSet);
                    try {
                        IResource[] members;
                        IResource[] iResourceArray = members = parent.members();
                        int n = members.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResource iResource = iResourceArray[n2];
                            visitor.visit(iResource);
                            ++n2;
                        }
                    }
                    catch (CoreException e) {
                        MercurialEclipsePlugin.logError(e);
                    }
                    Set<IResource> resources = this.getResources(8, parent);
                    for (IResource child : resources) {
                        try {
                            visitor.visit(child);
                        }
                        catch (CoreException e) {
                            MercurialEclipsePlugin.logError(e);
                        }
                    }
                    cloneBitSet = visitor.bitSet;
                }
            } else {
                cloneBitSet |= parentBitSet;
            }
            this.setStatus(location, cloneBitSet);
            ancestors.add((IResource)parent);
            parent = parent.getParent();
        }
        return ancestors;
    }

    private boolean isComputeDeepStatus() {
        return this.computeDeepStatus;
    }

    private boolean isCompleteStatus() {
        return this.completeStatus;
    }

    private int getBit(char status) {
        switch (status) {
            case '!': {
                return 4;
            }
            case 'R': {
                return 8;
            }
            case 'I': {
                return 0;
            }
            case 'C': {
                return 2;
            }
            case '?': {
                return 16;
            }
            case 'A': {
                return 32;
            }
            case 'M': {
                return 64;
            }
        }
        return 128;
    }

    public IProject[] getAllManagedProjects() {
        return this.knownStatus.keySet().toArray(new IProject[this.knownStatus.size()]);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() != 1) {
            return;
        }
        IResourceDelta delta = event.getDelta();
        HashMap<IProject, Set<IResource>> changed = new HashMap<IProject, Set<IResource>>();
        HashMap<IProject, Set<IResource>> added = new HashMap<IProject, Set<IResource>>();
        HashMap<IProject, Set<IResource>> removed = new HashMap<IProject, Set<IResource>>();
        ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(removed, changed, added);
        try {
            delta.accept((IResourceDeltaVisitor)visitor);
        }
        catch (CoreException e) {
            MercurialEclipsePlugin.logError(e);
            return;
        }
        HashSet changedProjects = new HashSet(changed.keySet());
        changedProjects.addAll(added.keySet());
        changedProjects.addAll(removed.keySet());
        for (IProject project : changedProjects) {
            Set addedSet = (Set)added.get(project);
            Set removedSet = (Set)removed.get(project);
            Set changedSet = (Set)changed.get(project);
            this.projectChanged(project, addedSet, removedSet, changedSet);
        }
    }

    private void projectChanged(IProject project, Set<IResource> addedSet, Set<IResource> removedSet, Set<IResource> changedSet) {
        Job[] jobs;
        ProjectUpdateJob updateJob = new ProjectUpdateJob(removedSet, changedSet, project, addedSet);
        Job[] jobArray = jobs = Job.getJobManager().find(ProjectUpdateJob.class);
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            if (updateJob.equals(job)) {
                job.cancel();
                if (this.debug) {
                    System.out.println("Status cache update cancelled for: " + ((ProjectUpdateJob)job).project.getName());
                }
            }
            ++n2;
        }
        updateJob.schedule(100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<IResource> refreshStatus(Set<IResource> resources, IProject project) throws HgException {
        if (resources == null || resources.isEmpty()) {
            return Collections.emptySet();
        }
        if (resources.contains(project)) {
            resources.remove(project);
            if (resources.isEmpty()) {
                return Collections.emptySet();
            }
        }
        int batchSize = this.getStatusBatchSize();
        ArrayList<IResource> currentBatch = new ArrayList<IResource>();
        HashSet<IResource> changed = new HashSet<IResource>();
        HgRoot root = AbstractClient.getHgRoot((IResource)project);
        Iterator<IResource> iterator = resources.iterator();
        while (iterator.hasNext()) {
            IResource resource = iterator.next();
            if (!resource.isTeamPrivateMember()) {
                currentBatch.add(resource);
            }
            if (currentBatch.size() % batchSize != 0 && iterator.hasNext()) continue;
            Object object = this.statusUpdateLock;
            synchronized (object) {
                for (IResource curr : currentBatch) {
                    boolean unknown = curr instanceof IContainer || this.isUnknown(curr);
                    this.clearStatusCache(curr);
                    if (!unknown || curr.exists()) continue;
                    IContainer directory = ResourceUtils.getFirstExistingDirectory(curr);
                    while (directory != null) {
                        changed.add((IResource)directory);
                        IPath parentPath = directory.getLocation();
                        this.bitMap.remove(parentPath);
                        this.statusMap.remove(parentPath);
                        directory = ResourceUtils.getFirstExistingDirectory((IResource)directory.getParent());
                    }
                    this.setStatusToAncestors(curr, _CLEAN);
                }
                String output = HgStatusClient.getStatusWithoutIgnored(root, currentBatch);
                changed.addAll(this.parseStatus(root, project, output));
            }
            currentBatch.clear();
        }
        if (!resources.isEmpty()) {
            changed.addAll(this.checkForConflict(project));
        }
        this.notifyChanged(changed, false);
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStatusCache(IResource resource) {
        Object object = this.statusUpdateLock;
        synchronized (object) {
            IPath parentPath = ResourceUtils.getPath(resource);
            if (resource instanceof IContainer) {
                Set entrySet = this.statusMap.keySet();
                Iterator it = entrySet.iterator();
                while (it.hasNext()) {
                    IPath path = (IPath)it.next();
                    if (path == null || !parentPath.isPrefixOf(path)) continue;
                    it.remove();
                    this.bitMap.remove(path);
                }
            } else {
                this.bitMap.remove(parentPath);
                this.statusMap.remove(parentPath);
            }
        }
    }

    private int getStatusBatchSize() {
        return this.statusBatchSize;
    }

    public Set<IFile> getLocalMembers(IResource resource) {
        HashSet<IFile> members = new HashSet<IFile>();
        if (resource instanceof IContainer) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            Set<IPath> children = this.getChildrenFromCache((IContainer)resource);
            for (IPath path : children) {
                IFile iFile;
                File file = path.toFile();
                if (file.isDirectory() || (iFile = root.getFileForLocation(path)) == null) continue;
                members.add(iFile);
            }
        } else {
            members.add((IFile)resource);
        }
        return members;
    }

    @Override
    protected void clearProjectCache(IProject project) {
        super.clearProjectCache(project);
        this.clear(project, false);
        this.knownStatus.remove(project);
    }

    public void clear(IProject project, boolean notify) {
        this.clearStatusCache((IResource)project);
        if (notify) {
            this.notifyChanged((IResource)project, false);
        }
    }

    private Set<IResource> addConflict(IResource local) {
        IPath location = local.getLocation();
        Integer status = this.statusMap.get(location);
        if (status == null) {
            this.setStatus(location, _CONFLICT);
        } else {
            status = status | 0x100;
            this.setStatus(location, status);
        }
        Set<IResource> changed = this.setStatusToAncestors(local, status);
        changed.add(local);
        return changed;
    }

    private boolean removeConflict(IResource local) {
        Integer statusInt = this.getStatus(local);
        if (statusInt == null) {
            return false;
        }
        int status = statusInt;
        if (Bits.contains(status, 256)) {
            status = Bits.clear(status, 256);
            this.setStatus(local.getLocation(), status);
            return true;
        }
        return false;
    }

    @Override
    protected void configureFromPreferences(IPreferenceStore store) {
        this.computeDeepStatus = store.getBoolean("hg.performance.computeDeepStatus");
        this.completeStatus = store.getBoolean("hg.performance.getStatusForCompleteRepository");
        this.statusBatchSize = store.getInt("hg.batchsize.status");
        if (this.statusBatchSize < 0) {
            this.statusBatchSize = 10;
            MercurialEclipsePlugin.logWarning(Messages.mercurialStatusCache_BatchSizeForStatusCommandNotCorrect, null);
        }
    }

    /* synthetic */ MercurialStatusCache(MercurialStatusCache mercurialStatusCache) {
        this();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BitMap {
        private final Set<IPath> IGNORE_SET = new HashSet<IPath>();
        private final Set<IPath> MISSING_SET = new HashSet<IPath>();
        private final Set<IPath> REMOVED_SET = new HashSet<IPath>();
        private final Set<IPath> UNKNOWN_SET = new HashSet<IPath>();
        private final Set<IPath> ADDED_SET = new HashSet<IPath>();
        private final Set<IPath> MODIFIED_SET = new HashSet<IPath>();
        private final Set<IPath> CONFLICT_SET = new HashSet<IPath>();

        void put(IPath path, Integer set) {
            int mask = set;
            if ((mask & 8) != 0) {
                this.REMOVED_SET.add(path);
            }
            if ((mask & 4) != 0) {
                this.MISSING_SET.add(path);
            }
            if ((mask & 0x10) != 0) {
                this.UNKNOWN_SET.add(path);
            }
            if ((mask & 0x20) != 0) {
                this.ADDED_SET.add(path);
            }
            if ((mask & 0x40) != 0) {
                this.MODIFIED_SET.add(path);
            }
            if ((mask & 0x100) != 0) {
                this.CONFLICT_SET.add(path);
            }
            if (false) {
                this.IGNORE_SET.add(path);
            }
        }

        Set<IPath> get(int bit) {
            switch (bit) {
                case 8: {
                    return this.REMOVED_SET;
                }
                case 4: {
                    return this.MISSING_SET;
                }
                case 16: {
                    return this.UNKNOWN_SET;
                }
                case 32: {
                    return this.ADDED_SET;
                }
                case 64: {
                    return this.MODIFIED_SET;
                }
                case 256: {
                    return this.CONFLICT_SET;
                }
                case 0: {
                    return this.IGNORE_SET;
                }
            }
            return null;
        }

        public void remove(IPath path) {
            this.remove(path, this.REMOVED_SET);
            this.remove(path, this.MISSING_SET);
            this.remove(path, this.UNKNOWN_SET);
            this.remove(path, this.ADDED_SET);
            this.remove(path, this.MODIFIED_SET);
            this.remove(path, this.CONFLICT_SET);
            this.remove(path, this.IGNORE_SET);
        }

        public void remove(IPath path, Set<IPath> set) {
            if (!set.isEmpty()) {
                set.remove(path);
            }
        }
    }

    private final class MemberStatusVisitor
    implements IResourceVisitor {
        private int bitSet;
        private final IContainer parent;

        public MemberStatusVisitor(IContainer parent, int bitSet) {
            this.bitSet = bitSet;
            this.parent = parent;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource != this.parent) {
                IPath location = ResourceUtils.getPath(resource);
                Integer memberBitSet = (Integer)MercurialStatusCache.this.statusMap.get(location);
                if (memberBitSet != null) {
                    int temp = Bits.clear(memberBitSet, 62);
                    if (Bits.contains(memberBitSet, 124)) {
                        temp |= 0x40;
                    }
                    this.bitSet |= temp;
                }
            }
            return true;
        }
    }

    private static final class MercurialStatusCacheHolder {
        public static final MercurialStatusCache instance = new MercurialStatusCache(null);

        private MercurialStatusCacheHolder() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ProjectUpdateJob
    extends Job {
        private final IProject project;
        private final Set<IResource> resources;

        private ProjectUpdateJob(Set<IResource> removedSet, Set<IResource> changedSet, IProject project, Set<IResource> addedSet) {
            super(Messages.mercurialStatusCache_RefreshStatus);
            this.project = project;
            this.resources = new HashSet<IResource>();
            if (removedSet != null) {
                this.resources.addAll(removedSet);
            }
            if (changedSet != null) {
                this.resources.addAll(changedSet);
            }
            if (addedSet != null) {
                this.resources.addAll(addedSet);
            }
            if (this.resources.contains(project) || this.resources.size() > 50) {
                this.resources.clear();
                this.resources.add((IResource)project);
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                try {
                    this.updateProject(monitor);
                }
                catch (CoreException e) {
                    MercurialEclipsePlugin.logError(e);
                    IStatus iStatus = e.getStatus();
                    monitor.done();
                    return iStatus;
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        private void updateProject(IProgressMonitor monitor) throws HgException {
            if (this.resources.size() == 1 && this.resources.contains(this.project)) {
                monitor.beginTask(NLS.bind((String)Messages.mercurialStatusCache_RefreshingProject, (Object)this.project.getName()), 1);
                MercurialStatusCache.this.refreshStatus((IResource)this.project, monitor);
            } else if (!this.resources.isEmpty()) {
                monitor.beginTask(Messages.mercurialStatusCache_RefreshingResources, 1);
                MercurialStatusCache.this.refreshStatus(this.resources, this.project);
            }
            monitor.worked(1);
        }

        public boolean belongsTo(Object family) {
            return ProjectUpdateJob.class.equals(family);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ProjectUpdateJob)) {
                return false;
            }
            ProjectUpdateJob job = (ProjectUpdateJob)((Object)obj);
            if (this.resources.size() != job.resources.size()) {
                return false;
            }
            if (!this.project.equals((Object)job.project)) {
                return false;
            }
            return this.resources.containsAll(job.resources);
        }

        public int hashCode() {
            return this.resources.size() + this.project.getName().hashCode();
        }
    }
}

