/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team.cache;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.team.cache.AbstractCache;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.team.core.RepositoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncomingChangesetCache
extends AbstractCache {
    private static IncomingChangesetCache instance;
    private final Map<HgRepositoryLocation, Map<IPath, SortedSet<ChangeSet>>> incomingChangeSets = new HashMap<HgRepositoryLocation, Map<IPath, SortedSet<ChangeSet>>>();

    private IncomingChangesetCache() {
    }

    public static synchronized IncomingChangesetCache getInstance() {
        if (instance == null) {
            instance = new IncomingChangesetCache();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(HgRepositoryLocation repo) {
        Map<HgRepositoryLocation, Map<IPath, SortedSet<ChangeSet>>> map = this.incomingChangeSets;
        synchronized (map) {
            this.incomingChangeSets.remove(repo);
        }
        Set<IProject> projects = MercurialEclipsePlugin.getRepoManager().getAllRepoLocationProjects(repo);
        for (IProject project : projects) {
            this.clearChangesets(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(HgRepositoryLocation repo, IProject project, boolean notify) {
        Map<HgRepositoryLocation, Map<IPath, SortedSet<ChangeSet>>> map = this.incomingChangeSets;
        synchronized (map) {
            Map<IPath, SortedSet<ChangeSet>> map2 = this.incomingChangeSets.get(repo);
            if (map2 != null) {
                map2.remove(project.getLocation());
                this.clearChangesets(project);
            }
        }
        if (notify) {
            this.notifyChanged((IResource)project, false);
        }
    }

    @Override
    protected void clearProjectCache(IProject project) {
        super.clearProjectCache(project);
        Set<HgRepositoryLocation> repos = MercurialEclipsePlugin.getRepoManager().getAllProjectRepoLocations(project);
        for (HgRepositoryLocation repo : repos) {
            this.clear(repo, project, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<ChangeSet> getIncomingChangeSets(IResource resource, HgRepositoryLocation repository) throws HgException {
        Map<HgRepositoryLocation, Map<IPath, SortedSet<ChangeSet>>> map = this.incomingChangeSets;
        synchronized (map) {
            SortedSet<ChangeSet> revisions;
            Map<IPath, SortedSet<ChangeSet>> incoming = this.incomingChangeSets.get(repository);
            if (incoming == null || resource instanceof IProject && incoming.get(resource.getLocation()) == null) {
                this.refreshIncomingChangeSets(resource.getProject(), repository);
                incoming = this.incomingChangeSets.get(repository);
            }
            if (incoming != null && (revisions = incoming.get(resource.getLocation())) != null) {
                return Collections.unmodifiableSortedSet(revisions);
            }
        }
        return new TreeSet<ChangeSet>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IResource> getIncomingMembers(IResource resource, HgRepositoryLocation repository) throws HgException {
        Map<HgRepositoryLocation, Map<IPath, SortedSet<ChangeSet>>> map = this.incomingChangeSets;
        synchronized (map) {
            Map<IPath, SortedSet<ChangeSet>> changeSets = this.getIncomingMap(resource, repository);
            return this.getMembers(resource, changeSets);
        }
    }

    private Map<IPath, SortedSet<ChangeSet>> getIncomingMap(IResource resource, HgRepositoryLocation repository) throws HgException {
        this.getIncomingChangeSets(resource, repository);
        return this.incomingChangeSets.get(repository);
    }

    public ChangeSet getNewestIncomingChangeSet(IResource resource) throws HgException {
        Set<HgRepositoryLocation> locs = MercurialEclipsePlugin.getRepoManager().getAllProjectRepoLocations(resource.getProject());
        TreeSet<ChangeSet> changeSets = new TreeSet<ChangeSet>();
        for (HgRepositoryLocation repository : locs) {
            ChangeSet candidate = this.getNewestIncomingChangeSet(resource, repository);
            if (candidate == null) continue;
            changeSets.add(candidate);
        }
        if (changeSets.size() > 0) {
            return (ChangeSet)changeSets.last();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeSet getNewestIncomingChangeSet(IResource resource, HgRepositoryLocation repository) throws HgException {
        if (MercurialStatusCache.getInstance().isSupervised(resource) || !resource.exists()) {
            Map<HgRepositoryLocation, Map<IPath, SortedSet<ChangeSet>>> map = this.incomingChangeSets;
            synchronized (map) {
                SortedSet<ChangeSet> revisions;
                Map<IPath, SortedSet<ChangeSet>> repoMap = this.getIncomingMap(resource, repository);
                if (repoMap != null && (revisions = repoMap.get(resource.getLocation())) != null && revisions.size() > 0) {
                    return revisions.last();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshIncomingChangeSets(IProject project, HgRepositoryLocation repositoryLocation) throws HgException {
        Assert.isNotNull((Object)project);
        if (RepositoryProvider.getProvider((IProject)project, (String)"com.vectrace.MercurialEclipse.team.MercurialTeamProvider") != null && project.isOpen()) {
            Map<HgRepositoryLocation, Map<IPath, SortedSet<ChangeSet>>> map = this.incomingChangeSets;
            synchronized (map) {
                this.addResourcesToCache(project, repositoryLocation, this.incomingChangeSets, ChangeSet.Direction.INCOMING);
            }
            this.notifyChanged((IResource)project, true);
        }
    }
}

