/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgBranchClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.team.DecoratorImages;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.team.Messages;
import com.vectrace.MercurialEclipse.team.ResourceProperties;
import com.vectrace.MercurialEclipse.team.cache.Bits;
import com.vectrace.MercurialEclipse.team.cache.IncomingChangesetCache;
import com.vectrace.MercurialEclipse.team.cache.LocalChangesetCache;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDecorator
extends LabelProvider
implements ILightweightLabelDecorator,
Observer {
    private static final MercurialStatusCache STATUS_CACHE = MercurialStatusCache.getInstance();
    private static final IncomingChangesetCache INCOMING_CACHE = IncomingChangesetCache.getInstance();
    private static final LocalChangesetCache LOCAL_CACHE = LocalChangesetCache.getInstance();
    private static String[] fonts = new String[]{"com.vectrace.mercurialeclipse.ui.colorsandfonts.addedFont", "com.vectrace.mercurialeclipse.ui.colorsandfonts.conflictFont", "com.vectrace.mercurialeclipse.ui.colorsandfonts.deletedFont", "com.vectrace.mercurialeclipse.ui.colorsandfonts.removedFont", "com.vectrace.mercurialeclipse.ui.colorsandfonts.unknownFont", "com.vectrace.mercurialeclipse.ui.colorsandfonts.ignoredFont", "com.vectrace.mercurialeclipse.ui.colorsandfonts.changedFont"};
    private static String[] colors = new String[]{"com.vectrace.mercurialeclipse.ui.colorsandfonts.addedBackgroundColor", "com.vectrace.mercurialeclipse.ui.colorsandfonts.addedForegroundColor", "com.vectrace.mercurialeclipse.ui.colorsandfonts.changedBackgroundColor", "com.vectrace.mercurialeclipse.ui.colorsandfonts.changedForegroundColor", "com.vectrace.mercurialeclipse.ui.colorsandfonts.conflictBackgroundColor", "com.vectrace.mercurialeclipse.ui.colorsandfonts.conflictForegroundColor", "com.vectrace.mercurialeclipse.ui.colorsandfonts.ignoredBackgroundColor", "com.vectrace.mercurialeclipse.ui.colorsandfonts.ignoredForegroundColor", "com.vectrace.mercurialeclipse.ui.colorsandfonts.deletedBackgroundColor", "com.vectrace.mercurialeclipse.ui.colorsandfonts.deletedForegroundColor", "com.vectrace.mercurialeclipse.ui.colorsandfonts.removedBackgroundColor", "com.vectrace.mercurialeclipse.ui.colorsandfonts.removedForegroundColor", "com.vectrace.mercurialeclipse.ui.colorsandfonts.unknownBackgroundColor", "com.vectrace.mercurialeclipse.ui.colorsandfonts.unknownForegroundColor"};
    private static final Set<String> interestingPrefs = new HashSet<String>();
    private boolean folder_logic_2MM;
    private ITheme theme;
    private boolean colorise;
    private boolean showChangeset;

    static {
        interestingPrefs.add("2-means-modified");
        interestingPrefs.add("hg.labeldecorator.logic");
        interestingPrefs.add("hg.labeldecorator.colors");
        interestingPrefs.add("hg.performance.fileShowsChangeset");
    }

    public ResourceDecorator() {
        this.configureFromPreferences();
        STATUS_CACHE.addObserver(this);
        INCOMING_CACHE.addObserver(this);
        this.theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        this.ensureFontAndColorsCreated(fonts, colors);
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (!"CHANGE_CURRENT_THEME".equals(event.getProperty())) {
                    return;
                }
                ResourceDecorator.this.theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
                ResourceDecorator.this.ensureFontAndColorsCreated(fonts, colors);
            }
        });
        MercurialEclipsePlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (interestingPrefs.contains(event.getProperty())) {
                    ResourceDecorator.this.configureFromPreferences();
                    ResourceDecorator.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)ResourceDecorator.this));
                }
            }
        });
    }

    private void ensureFontAndColorsCreated(final String[] f, final String[] c) {
        MercurialEclipsePlugin.getStandardDisplay().syncExec(new Runnable(){

            public void run() {
                int i = 0;
                while (i < c.length) {
                    ResourceDecorator.this.theme.getColorRegistry().get(c[i]);
                    ++i;
                }
                i = 0;
                while (i < f.length) {
                    ResourceDecorator.this.theme.getFontRegistry().get(f[i]);
                    ++i;
                }
            }
        });
    }

    public void dispose() {
        STATUS_CACHE.deleteObserver(this);
        INCOMING_CACHE.deleteObserver(this);
        super.dispose();
    }

    private void configureFromPreferences() {
        IPreferenceStore store = MercurialEclipsePlugin.getDefault().getPreferenceStore();
        this.folder_logic_2MM = "2-means-modified".equals(store.getString("hg.labeldecorator.logic"));
        this.colorise = store.getBoolean("hg.labeldecorator.colors");
        this.showChangeset = store.getBoolean("hg.performance.fileShowsChangeset");
    }

    public void decorate(Object element, IDecoration d) {
        IResource resource = (IResource)element;
        IProject project = resource.getProject();
        if (project == null || !project.isAccessible()) {
            return;
        }
        try {
            if (!MercurialUtilities.hgIsTeamProviderFor(resource, false)) {
                return;
            }
            if (this.showChangeset) {
                if (!STATUS_CACHE.isStatusKnown(project) && !LOCAL_CACHE.isLocallyKnown((IResource)project)) {
                    d.addOverlay(DecoratorImages.notTrackedDescriptor);
                    if (resource == project) {
                        d.addSuffix(" [ Hg status pending... ]");
                    }
                    return;
                }
            } else if (!STATUS_CACHE.isStatusKnown(project)) {
                d.addOverlay(DecoratorImages.notTrackedDescriptor);
                if (resource == project) {
                    d.addSuffix(" [ Hg status pending... ]");
                }
                return;
            }
            ImageDescriptor overlay = null;
            StringBuilder prefix = new StringBuilder(2);
            Integer output = STATUS_CACHE.getStatus(resource);
            if (output != null) {
                overlay = this.decorate(output, prefix, d, this.colorise);
            }
            if (overlay != null) {
                d.addOverlay(overlay);
            }
            if (!this.showChangeset) {
                if (resource.getType() == 4) {
                    d.addSuffix(this.getSuffixForProject(project));
                }
            } else {
                this.addChangesetInfo(d, resource, project, prefix);
            }
            if (prefix.length() > 0) {
                d.addPrefix(prefix.toString());
            }
        }
        catch (Exception e) {
            MercurialEclipsePlugin.logError(e);
        }
    }

    private ImageDescriptor decorate(int statusBits, StringBuilder prefix, IDecoration d, boolean coloriseLabels) {
        ImageDescriptor overlay = null;
        if (this.folder_logic_2MM && (Bits.cardinality(statusBits) > 2 || Bits.cardinality(statusBits) == 2 && !Bits.contains(statusBits, 0))) {
            overlay = DecoratorImages.modifiedDescriptor;
            prefix.append('>');
            if (coloriseLabels) {
                this.setBackground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.changedBackgroundColor");
                this.setForeground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.changedForegroundColor");
                this.setFont(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.changedFont");
            }
        } else {
            switch (Bits.highestBit(statusBits)) {
                case 0: {
                    if (!coloriseLabels) break;
                    this.setBackground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.ignoredBackgroundColor");
                    this.setForeground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.ignoredForegroundColor");
                    this.setFont(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.ignoredFont");
                    break;
                }
                case 64: {
                    overlay = DecoratorImages.modifiedDescriptor;
                    prefix.append('>');
                    if (!coloriseLabels) break;
                    this.setBackground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.changedBackgroundColor");
                    this.setForeground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.changedForegroundColor");
                    this.setFont(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.changedFont");
                    break;
                }
                case 32: {
                    overlay = DecoratorImages.addedDescriptor;
                    prefix.append('>');
                    if (!coloriseLabels) break;
                    this.setBackground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.addedBackgroundColor");
                    this.setForeground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.addedForegroundColor");
                    this.setFont(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.addedFont");
                    break;
                }
                case 16: {
                    overlay = DecoratorImages.notTrackedDescriptor;
                    prefix.append('>');
                    if (!coloriseLabels) break;
                    this.setBackground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.unknownBackgroundColor");
                    this.setForeground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.unknownForegroundColor");
                    this.setFont(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.unknownFont");
                    break;
                }
                case 2: {
                    overlay = DecoratorImages.managedDescriptor;
                    break;
                }
                case 8: {
                    overlay = DecoratorImages.removedDescriptor;
                    prefix.append('>');
                    if (!coloriseLabels) break;
                    this.setBackground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.removedBackgroundColor");
                    this.setForeground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.removedForegroundColor");
                    this.setFont(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.removedFont");
                    break;
                }
                case 4: {
                    overlay = DecoratorImages.deletedStillTrackedDescriptor;
                    prefix.append('>');
                    if (!coloriseLabels) break;
                    this.setBackground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.deletedBackgroundColor");
                    this.setForeground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.deletedForegroundColor");
                    this.setFont(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.deletedFont");
                    break;
                }
                case 256: {
                    overlay = DecoratorImages.conflictDescriptor;
                    prefix.append('>');
                    if (!coloriseLabels) break;
                    this.setBackground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.conflictBackgroundColor");
                    this.setForeground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.conflictForegroundColor");
                    this.setFont(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.conflictFont");
                }
            }
        }
        return overlay;
    }

    private void addChangesetInfo(IDecoration d, IResource resource, IProject project, StringBuilder prefix) throws CoreException {
        ChangeSet newestIncomingChangeSet = INCOMING_CACHE.getNewestIncomingChangeSet(resource);
        if (newestIncomingChangeSet != null) {
            if (prefix.length() == 0) {
                prefix.append('<');
            } else {
                prefix.insert(0, '<');
            }
        }
        try {
            String suffix = "";
            if (resource.getType() == 4) {
                suffix = this.getSuffixForProject(project);
            }
            if (resource.getType() == 1) {
                suffix = this.getSuffixForFiles(resource, newestIncomingChangeSet);
            }
            if (resource.getType() != 2 && suffix.length() > 0) {
                d.addSuffix(suffix);
            }
        }
        catch (HgException e) {
            MercurialEclipsePlugin.logWarning(String.valueOf(Messages.getString("ResourceDecorator.couldntGetVersionOfResource")) + resource, (Throwable)((Object)e));
        }
    }

    private void setBackground(IDecoration d, String id) {
        d.setBackgroundColor(this.theme.getColorRegistry().get(id));
    }

    private void setForeground(IDecoration d, String id) {
        d.setForegroundColor(this.theme.getColorRegistry().get(id));
    }

    private void setFont(IDecoration d, String id) {
        d.setFont(this.theme.getFontRegistry().get(id));
    }

    private String getSuffixForFiles(IResource resource, ChangeSet cs) throws HgException {
        ChangeSet fileCs;
        String suffix = "";
        if (!STATUS_CACHE.isAdded(resource.getLocation()) && (fileCs = LOCAL_CACHE.getNewestLocalChangeSet(resource)) != null) {
            suffix = " [" + fileCs.getChangesetIndex() + " - " + fileCs.getAgeDate() + " - " + fileCs.getUser() + "]";
            if (cs != null) {
                suffix = String.valueOf(suffix) + "< [" + cs.getChangesetIndex() + ":" + cs.getNodeShort() + " - " + cs.getAgeDate() + " - " + cs.getUser() + "]";
            }
        }
        return suffix;
    }

    private String getSuffixForProject(IProject project) throws CoreException {
        ChangeSet changeSet = null;
        String suffix = "";
        if (this.showChangeset) {
            LocalChangesetCache.getInstance().getLocalChangeSets((IResource)project);
        }
        if ((changeSet = LocalChangesetCache.getInstance().getCurrentWorkDirChangeset((IResource)project)) == null) {
            suffix = Messages.getString("ResourceDecorator.new");
        } else {
            suffix = " [ ";
            String hex = ":" + changeSet.getNodeShort();
            String tags = changeSet.getTag();
            String merging = project.getPersistentProperty(ResourceProperties.MERGING);
            suffix = String.valueOf(suffix) + changeSet.getChangesetIndex() + hex;
            String branch = (String)project.getSessionProperty(ResourceProperties.HG_BRANCH);
            if (branch == null) {
                branch = HgBranchClient.getActiveBranch(project.getLocation().toFile());
                project.setSessionProperty(ResourceProperties.HG_BRANCH, (Object)branch);
            }
            if (branch.length() > 0 && !"default".equals(branch)) {
                suffix = String.valueOf(suffix) + " @ " + branch;
            }
            if (tags != null && tags.length() > 0) {
                suffix = String.valueOf(suffix) + " (" + tags + ")";
            }
            if (merging != null && merging.length() > 0) {
                suffix = String.valueOf(suffix) + Messages.getString("ResourceDecorator.merging") + merging;
            }
            suffix = String.valueOf(suffix) + " ]";
        }
        return suffix;
    }

    public static String getDecoratorId() {
        String decoratorId = ResourceDecorator.class.getName();
        return decoratorId;
    }

    @Override
    public void update(Observable o, Object updatedObject) {
        if (updatedObject instanceof Set) {
            Set changed = (Set)updatedObject;
            ArrayList<IResource> notification = new ArrayList<IResource>(1000);
            int i = 0;
            for (IResource resource : changed) {
                if (i % 1000 == 0 && notification.size() > 0) {
                    this.fireNotification(notification);
                }
                notification.add(resource);
                ++i;
            }
            if (notification.size() > 0) {
                this.fireNotification(notification);
            }
        }
    }

    private void fireNotification(List<IResource> notification) {
        LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this, notification.toArray());
        this.fireLabelProviderChanged(event);
        notification.clear();
    }
}

