/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.team.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultipleFilesAction
implements IActionDelegate {
    private List<IFile> selection;

    public void selectionChanged(IAction action, ISelection sel) {
        if (sel instanceof IStructuredSelection) {
            this.selection = new ArrayList<IFile>();
            this.extractFiles(this.selection, Arrays.asList(((IStructuredSelection)sel).toArray()).toArray(new IResource[0]));
        }
    }

    private void extractFiles(List<IFile> list, IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile) {
                list.add((IFile)resource);
            } else if (resource instanceof IContainer) {
                try {
                    this.extractFiles(list, ((IContainer)resource).members());
                }
                catch (CoreException e) {
                    MercurialEclipsePlugin.logError(e);
                }
            } else {
                MercurialEclipsePlugin.logWarning(String.valueOf(Messages.getString("MultipleFilesAction.unexpectedResourceType")) + resource.getClass(), null);
            }
            ++n2;
        }
    }

    protected Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    protected List<IFile> getSelectedFiles() {
        return this.selection;
    }

    public void run(IAction action) {
        try {
            this.run(this.getSelectedFiles());
        }
        catch (Exception e) {
            MercurialEclipsePlugin.logError(e);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("MultipleFilesAction.hgSays"), (String)(String.valueOf(e.getMessage()) + Messages.getString("MultipleFilesAction.seeErrorLog")));
        }
    }

    protected abstract void run(List<IFile> var1) throws Exception;
}

