/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team;

import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.commands.HgRootClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.history.MercurialHistoryProvider;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.team.HgMoveDeleteHook;
import com.vectrace.MercurialEclipse.team.ResourceProperties;
import com.vectrace.MercurialEclipse.utils.ResourceUtils;
import java.io.File;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileHistoryProvider;

public class MercurialTeamProvider
extends RepositoryProvider {
    public static final String ID = "com.vectrace.MercurialEclipse.team.MercurialTeamProvider";
    public static final QualifiedName QUALIFIED_NAME_PROJECT_SOURCE_REPOSITORY = new QualifiedName("com.vectrace.MercurialEclipse.team.MercurialTeamProvider.projectSourceRepository", "MercurialEclipseProjectSourceRepository");
    public static final QualifiedName QUALIFIED_NAME_DEFAULT_REVISION_LIMIT = new QualifiedName("com.vectrace.MercurialEclipse.team.MercurialTeamProvider.defaultRevisionLimit", "defaultRevisionLimit");
    private static final Map<IProject, Boolean> HG_ROOTS = new HashMap<IProject, Boolean>();
    private MercurialHistoryProvider FileHistoryProvider;

    public void configureProject() throws CoreException {
        IProject project = this.getProject();
        HG_ROOTS.put(project, Boolean.TRUE);
        MercurialTeamProvider.getHgRoot((IResource)project);
        project.refreshLocal(2, null);
        IResource hgDir = project.findMember(".hg");
        if (hgDir != null && hgDir.exists()) {
            hgDir.setTeamPrivateMember(true);
            hgDir.setDerived(true);
        }
    }

    public void deconfigure() throws CoreException {
        IProject project = this.getProject();
        assert (project != null);
        HG_ROOTS.put(project, Boolean.FALSE);
        project.setPersistentProperty(ResourceProperties.HG_ROOT, null);
        project.setPersistentProperty(ResourceProperties.MERGING, null);
        project.setSessionProperty(ResourceProperties.MERGE_COMMIT_OFFERED, null);
    }

    public static boolean hgIsTeamProviderFor(IProject project) {
        Assert.isNotNull((Object)project);
        Boolean result = HG_ROOTS.get(project);
        if (result == null) {
            result = RepositoryProvider.getProvider((IProject)project, (String)ID) != null;
            HG_ROOTS.put(project, result);
        }
        return result;
    }

    private static HgRoot getAndStoreHgRoot(IResource resource) throws HgException {
        HgRoot hgRoot;
        assert (resource != null);
        IProject project = resource.getProject();
        if (project == null || !resource.exists()) {
            return AbstractClient.getHgRoot(resource);
        }
        try {
            hgRoot = (HgRoot)project.getSessionProperty(ResourceProperties.HG_ROOT);
            if (hgRoot == null) {
                hgRoot = AbstractClient.getHgRoot(resource);
                MercurialTeamProvider.setRepositoryEncoding(project, hgRoot);
                project.setSessionProperty(ResourceProperties.HG_ROOT, (Object)hgRoot);
            }
        }
        catch (CoreException e) {
            throw new HgException(e);
        }
        return hgRoot;
    }

    private static void setRepositoryEncoding(IProject project, HgRoot hgRoot) throws CoreException {
        String encoding = null;
        if (project != null && (encoding = project.getDefaultCharset()) != null) {
            hgRoot.setEncoding(Charset.forName(encoding));
        }
    }

    private static HgRoot getHgRootFile(File file) throws HgException {
        assert (file != null);
        return HgRootClient.getHgRoot(file);
    }

    private static HgRoot getAndStoreHgRoot(File file) throws CoreException {
        assert (file != null);
        IResource resource = ResourceUtils.convert(file);
        if (resource != null) {
            return MercurialTeamProvider.getAndStoreHgRoot(resource);
        }
        return MercurialTeamProvider.getHgRootFile(file);
    }

    public static File getHgRootConfig(IResource resource) throws HgException {
        assert (resource != null);
        HgRoot hgRoot = MercurialTeamProvider.getHgRoot(resource);
        return hgRoot.getConfig();
    }

    public static HgRoot getHgRoot(IResource resource) throws HgException {
        assert (resource != null);
        try {
            return MercurialTeamProvider.getAndStoreHgRoot(resource);
        }
        catch (CoreException e) {
            throw new HgException(e.getLocalizedMessage(), e);
        }
    }

    public static HgRoot getHgRoot(File file) throws CoreException {
        assert (file != null);
        return MercurialTeamProvider.getAndStoreHgRoot(file);
    }

    public String getID() {
        return ID;
    }

    public IMoveDeleteHook getMoveDeleteHook() {
        return new HgMoveDeleteHook();
    }

    public IFileHistoryProvider getFileHistoryProvider() {
        if (this.FileHistoryProvider == null) {
            this.FileHistoryProvider = new MercurialHistoryProvider();
        }
        return this.FileHistoryProvider;
    }

    public boolean canHandleLinkedResources() {
        return true;
    }

    public boolean canHandleLinkedResourceURI() {
        return this.canHandleLinkedResources();
    }
}

