/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.SafeWorkspaceJob;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.dialogs.RevertDialog;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.menu.UpdateHandler;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.team.Messages;
import com.vectrace.MercurialEclipse.team.ResourceProperties;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import com.vectrace.MercurialEclipse.utils.ResourceUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionRevert
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    private IStructuredSelection selection;

    public void dispose() {
    }

    public void init(IWorkbenchWindow w) {
        this.window = w;
    }

    public void run(IAction action) {
        boolean mergeIsRunning;
        if (this.window == null) {
            this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        ArrayList<IResource> resources = new ArrayList<IResource>();
        try {
            mergeIsRunning = this.collectResourcesToRevert(resources);
        }
        catch (CoreException e) {
            MercurialEclipsePlugin.logError(e);
            MercurialEclipsePlugin.showError(e);
            return;
        }
        if (resources.size() > 0 && !mergeIsRunning) {
            this.openRevertDialog(resources, false);
        } else if (mergeIsRunning) {
            boolean doRevert = MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("ActionRevert.HgRevert"), (String)Messages.getString("ActionRevert.mergeIsRunning"));
            if (doRevert) {
                this.openRevertDialog(resources, true);
            }
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.getString("ActionRevert.HgRevert"), (String)Messages.getString("ActionRevert.noFilesToRevert"));
        }
    }

    private Shell getShell() {
        Shell shell = this.window != null && this.window.getShell() != null ? this.window.getShell() : PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        return shell;
    }

    private void openRevertDialog(List<IResource> resources, final boolean cleanAfterMerge) {
        List<Object> untracked;
        List<IResource> result;
        if (!cleanAfterMerge) {
            RevertDialog chooser = new RevertDialog(Display.getCurrent().getActiveShell());
            chooser.setFiles(resources);
            if (chooser.open() != 0) {
                return;
            }
            result = chooser.getSelectionForHgRevert();
            untracked = chooser.getUntrackedSelection();
        } else {
            result = resources;
            untracked = new ArrayList();
        }
        new SafeWorkspaceJob(Messages.getString("ActionRevert.revertFiles")){

            protected IStatus runSafe(IProgressMonitor monitor) {
                try {
                    ActionRevert.this.doRevert(monitor, result, untracked, cleanAfterMerge);
                }
                catch (HgException e) {
                    MercurialEclipsePlugin.logError((Throwable)((Object)e));
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private boolean collectResourcesToRevert(List<IResource> resources) throws CoreException, HgException {
        boolean mergeIsRunning = false;
        for (Object obj : this.selection.toList()) {
            boolean supervised;
            boolean merging;
            if (!(obj instanceof IResource)) continue;
            IResource resource = (IResource)obj;
            boolean bl = merging = resource.getProject().getPersistentProperty(ResourceProperties.MERGING) != null;
            if (merging) {
                mergeIsRunning = true;
            }
            if (!(supervised = MercurialUtilities.hgIsTeamProviderFor(resource, false))) continue;
            resources.add(resource);
        }
        return mergeIsRunning;
    }

    public void doRevert(IProgressMonitor monitor, List<IResource> resources, List<IResource> untracked, boolean cleanAfterMerge) throws HgException {
        monitor.beginTask(Messages.getString("ActionRevert.revertingResources"), resources.size() * 2);
        Map<IProject, List<IResource>> filesToRevert = ResourceUtils.groupByProject(resources);
        Set<IProject> projects = filesToRevert.keySet();
        this.deleteUntrackedFiles(untracked, monitor);
        MercurialStatusCache cache = MercurialStatusCache.getInstance();
        Map<IProject, Set<IResource>> removedFilesBefore = this.getFiles(8, projects);
        Map<IProject, Set<IResource>> addedFilesBefore = this.getFiles(32, removedFilesBefore.keySet());
        removedFilesBefore.keySet().retainAll(addedFilesBefore.keySet());
        if (cleanAfterMerge) {
            for (Map.Entry<IProject, List<IResource>> entry : filesToRevert.entrySet()) {
                this.performRevertAfterMerge(monitor, entry.getKey(), entry.getValue());
            }
        } else {
            Map<HgRoot, List<IResource>> map = ResourceUtils.groupByRoot(resources);
            for (Map.Entry<HgRoot, List<IResource>> entry : map.entrySet()) {
                this.performRegularRevert(monitor, entry.getKey(), entry.getValue());
            }
        }
        for (IResource iResource : resources) {
            monitor.subTask(String.valueOf(Messages.getString("ActionRevert.refreshing")) + iResource.getName() + "...");
            try {
                if (cache.isAdded(ResourceUtils.getPath(iResource))) {
                    iResource.touch(monitor);
                }
                iResource.refreshLocal(1, monitor);
            }
            catch (CoreException coreException) {
                MercurialEclipsePlugin.logError(coreException);
            }
            monitor.worked(1);
        }
        for (Map.Entry<IProject, Set<IResource>> entry : removedFilesBefore.entrySet()) {
            cache.refreshStatus((IResource)entry.getKey(), monitor);
        }
        HashMap<IProject, Set<IResource>> hashMap = new HashMap<IProject, Set<IResource>>();
        Map<IProject, Set<IResource>> map = this.getFiles(8, removedFilesBefore.keySet());
        for (Map.Entry<IProject, Set<IResource>> entry : removedFilesBefore.entrySet()) {
            List<IResource> reverted;
            IProject projBefore = entry.getKey();
            Set<IResource> set = entry.getValue();
            Set<IResource> removedAfter = map.get(projBefore);
            if (removedAfter != null && !removedAfter.isEmpty()) {
                set.removeAll(removedAfter);
            }
            if ((reverted = filesToRevert.get(projBefore)) != null && !reverted.isEmpty()) {
                set.removeAll(reverted);
            }
            if (set.isEmpty()) continue;
            hashMap.put(projBefore, set);
        }
        for (Map.Entry<Object, Set<Object>> entry : hashMap.entrySet()) {
            Set<Object> removed = entry.getValue();
            for (IResource iResource : removed) {
                try {
                    iResource.refreshLocal(1, monitor);
                }
                catch (CoreException e) {
                    MercurialEclipsePlugin.logError(e);
                }
            }
        }
        monitor.done();
    }

    private void deleteUntrackedFiles(List<IResource> untracked, IProgressMonitor monitor) {
        MercurialStatusCache cache = MercurialStatusCache.getInstance();
        for (IResource resource : untracked) {
            try {
                IContainer parent = null;
                if (resource instanceof IFile) {
                    parent = resource.getParent();
                    if (parent instanceof IProject && ".project".equals(resource.getName())) {
                        MercurialEclipsePlugin.logInfo("Will NOT delete .project file from project " + parent.getName(), null);
                        continue;
                    }
                    resource.delete(3, monitor);
                } else if (!(resource instanceof IProject)) {
                    resource.delete(2, monitor);
                }
                this.deleteEmptyDirs(parent, monitor);
                cache.clearStatusCache(resource);
            }
            catch (CoreException e) {
                MercurialEclipsePlugin.logError(e);
            }
        }
    }

    private void deleteEmptyDirs(IContainer dir, IProgressMonitor monitor) throws CoreException {
        int memberFlags = 10;
        if (dir != null && !(dir instanceof IProject) && dir.members(memberFlags).length == 0) {
            IContainer parent = dir.getParent();
            dir.delete(false, monitor);
            this.deleteEmptyDirs(parent, monitor);
        }
    }

    private Map<IProject, Set<IResource>> getFiles(int statusBit, Set<IProject> projects) {
        MercurialStatusCache cache = MercurialStatusCache.getInstance();
        HashMap<IProject, Set<IResource>> resources = new HashMap<IProject, Set<IResource>>();
        for (IProject project : projects) {
            Set<IResource> removed = cache.getResources(statusBit, (IContainer)project);
            if (removed.isEmpty()) continue;
            resources.put(project, removed);
        }
        return resources;
    }

    private void performRegularRevert(IProgressMonitor monitor, HgRoot root, List<IResource> resources) throws HgException {
        HgCommand command = new HgCommand("revert", (File)root, true);
        command.setUsePreferenceTimeout("hg.timeout.update");
        command.addOptions("--no-backup");
        command.addFiles(resources);
        monitor.subTask(String.valueOf(Messages.getString("ActionRevert.reverting")) + root.getName() + "...");
        command.executeToString();
        monitor.worked(1);
    }

    private void performRevertAfterMerge(IProgressMonitor monitor, IProject root, List<IResource> resources) {
        try {
            UpdateHandler update = new UpdateHandler();
            update.setCleanEnabled(true);
            update.setRevision(".");
            update.setShell(this.getShell());
            update.run((IResource)root);
        }
        catch (Exception e) {
            MercurialEclipsePlugin.logError(e);
        }
    }

    public void selectionChanged(IAction action, ISelection in_selection) {
        if (in_selection != null && in_selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)in_selection;
        }
    }
}

