/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.synchronize;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.synchronize.MercurialResourceVariant;
import com.vectrace.MercurialEclipse.team.MercurialRevisionStorage;
import com.vectrace.MercurialEclipse.team.cache.LocalChangesetCache;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;

public class MercurialResourceVariantComparator
implements IResourceVariantComparator {
    private static MercurialStatusCache statusCache = MercurialStatusCache.getInstance();
    private ChangeSet csWorkDir;

    public boolean compare(IResource local, IResourceVariant repoRevision) {
        try {
            if (this.csWorkDir == null) {
                this.csWorkDir = LocalChangesetCache.getInstance().getCurrentWorkDirChangeset(local);
            }
        }
        catch (HgException e) {
            MercurialEclipsePlugin.logError((Throwable)((Object)e));
            return false;
        }
        if (!statusCache.isClean(local)) {
            return false;
        }
        if (repoRevision == null) {
            return true;
        }
        try {
            MercurialRevisionStorage remoteIStorage = (MercurialRevisionStorage)repoRevision.getStorage(null);
            ChangeSet cs = remoteIStorage.getChangeSet();
            return cs.getDirection() != ChangeSet.Direction.INCOMING && cs.getDirection() != ChangeSet.Direction.OUTGOING || !cs.getBranch().equals(this.csWorkDir.getBranch());
        }
        catch (TeamException e) {
            MercurialEclipsePlugin.logError(e);
            return false;
        }
    }

    public boolean compare(IResourceVariant base, IResourceVariant remote) {
        MercurialResourceVariant mrv = (MercurialResourceVariant)remote;
        if (this.csWorkDir != null && mrv.getRev().getChangeSet().getBranch().equals(this.csWorkDir.getBranch())) {
            return base.getContentIdentifier().equals(remote.getContentIdentifier());
        }
        return true;
    }

    public boolean isThreeWay() {
        return true;
    }
}

