/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.synchronize;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.synchronize.MercurialSynchronizeSubscriber;
import com.vectrace.MercurialEclipse.synchronize.Messages;
import com.vectrace.MercurialEclipse.team.cache.IncomingChangesetCache;
import com.vectrace.MercurialEclipse.team.cache.LocalChangesetCache;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import com.vectrace.MercurialEclipse.team.cache.OutgoingChangesetCache;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberChangeEvent;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HgSubscriberScopeManager
extends SubscriberScopeManager
implements Observer {
    public static final int INCOMING = -1;
    public static final int OUTGOING = -2;
    public static final int LOCAL = -3;

    public HgSubscriberScopeManager(ResourceMapping[] inputMappings, MercurialSynchronizeSubscriber subscriber) {
        super(HgSubscriberScopeManager.class.getSimpleName(), inputMappings, (Subscriber)subscriber, false);
        MercurialStatusCache.getInstance().addObserver(this);
        IncomingChangesetCache.getInstance().addObserver(this);
        OutgoingChangesetCache.getInstance().addObserver(this);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!(arg instanceof Set)) {
            return;
        }
        HashSet<ISubscriberChangeEvent> changeEvents = new HashSet<ISubscriberChangeEvent>();
        Set resources = (Set)arg;
        IResource[] roots = this.getSubscriber().roots();
        boolean projectRefresh = false;
        int flags = 1;
        block0: for (Object res : resources) {
            if (!(res instanceof IResource)) continue;
            IResource resource = (IResource)res;
            IResource[] iResourceArray = roots;
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IResource root = iResourceArray[n2];
                if (root.contains((ISchedulingRule)resource)) {
                    if (!projectRefresh && resource.contains((ISchedulingRule)root)) {
                        projectRefresh = true;
                    }
                    changeEvents.add((ISubscriberChangeEvent)new HgSubscriberChangeEvent(this.getSubscriber(), flags, resource));
                    continue block0;
                }
                ++n2;
            }
        }
        if (changeEvents.size() == 0) {
            return;
        }
        if (resources.size() == 1 && projectRefresh) {
            if (MercurialEclipsePlugin.getDefault().isDebugging()) {
                System.out.println("! Update data from: " + o + " : " + resources.size());
            }
            int flag = 0;
            if (o instanceof IncomingChangesetCache) {
                flag = -1;
            } else if (o instanceof OutgoingChangesetCache || o instanceof LocalChangesetCache) {
                flag = -2;
            } else if (o instanceof MercurialStatusCache) {
                flag = -3;
            }
            this.updateData(roots, flag);
        } else {
            if (MercurialEclipsePlugin.getDefault().isDebugging()) {
                System.out.println("Update UI from: " + o + " : " + resources.size());
            }
            this.updateUI(changeEvents);
        }
    }

    public void dispose() {
        MercurialStatusCache.getInstance().deleteObserver(this);
        IncomingChangesetCache.getInstance().deleteObserver(this);
        OutgoingChangesetCache.getInstance().deleteObserver(this);
        super.dispose();
    }

    private void updateUI(Set<ISubscriberChangeEvent> events) {
        Job[] jobs;
        UpdateUIJob updateJob = new UpdateUIJob(events, (MercurialSynchronizeSubscriber)this.getSubscriber());
        Job[] jobArray = jobs = Job.getJobManager().find(UpdateUIJob.class);
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            if (updateJob.equals(job)) {
                job.cancel();
                if (MercurialEclipsePlugin.getDefault().isDebugging()) {
                    System.out.println("Cancelled refresh UI: " + ((UpdateUIJob)job).events.size());
                }
            }
            ++n2;
        }
        updateJob.schedule(500L);
    }

    private void updateData(IResource[] roots, int flag) {
        Job[] jobs;
        UpdateDataJob updateJob = new UpdateDataJob(flag, roots, (MercurialSynchronizeSubscriber)this.getSubscriber());
        Job[] jobArray = jobs = Job.getJobManager().find(UpdateDataJob.class);
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            if (updateJob.equals(job)) {
                job.cancel();
                if (MercurialEclipsePlugin.getDefault().isDebugging()) {
                    System.out.println("Cancelled refresh data: " + flag);
                }
            }
            ++n2;
        }
        updateJob.schedule(200L);
    }

    private static class HgSubscriberChangeEvent
    extends SubscriberChangeEvent {
        public HgSubscriberChangeEvent(Subscriber subscriber, int flags, IResource resource) {
            super(subscriber, flags, resource);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof HgSubscriberChangeEvent)) {
                return false;
            }
            HgSubscriberChangeEvent event = (HgSubscriberChangeEvent)((Object)obj);
            return this.getResource().equals((Object)event.getResource());
        }

        public int hashCode() {
            return this.getResource().hashCode();
        }
    }

    private static class UpdateDataJob
    extends Job {
        private final int flag;
        private final IResource[] roots;
        private final MercurialSynchronizeSubscriber subscriber;

        public UpdateDataJob(int flag, IResource[] roots, MercurialSynchronizeSubscriber subscriber) {
            super("Hg subscriber data update");
            this.flag = flag;
            this.roots = roots;
            this.subscriber = subscriber;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(Messages.getString("MercurialSynchronizeSubscriber.refreshingResources"), 5);
            try {
                try {
                    this.subscriber.refresh(this.roots, this.flag, monitor);
                }
                catch (TeamException e) {
                    MercurialEclipsePlugin.logError(e);
                    IStatus iStatus = Status.CANCEL_STATUS;
                    monitor.done();
                    return iStatus;
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return UpdateDataJob.class.equals(family);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UpdateDataJob)) {
                return false;
            }
            UpdateDataJob job = (UpdateDataJob)((Object)obj);
            if (this.flag != job.flag) {
                return false;
            }
            return ((Object)((Object)this.subscriber)).equals((Object)job.subscriber);
        }

        public int hashCode() {
            return this.flag + ((Object)((Object)this.subscriber)).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UpdateUIJob
    extends Job {
        private final MercurialSynchronizeSubscriber subscriber;
        private final Set<ISubscriberChangeEvent> events;

        public UpdateUIJob(Set<ISubscriberChangeEvent> events, MercurialSynchronizeSubscriber subscriber) {
            super("Hg subscriber UI update");
            this.events = events;
            this.subscriber = subscriber;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(Messages.getString("MercurialSynchronizeSubscriber.refreshingResources"), 1);
            try {
                ISubscriberChangeEvent[] deltas = this.events.toArray(new ISubscriberChangeEvent[this.events.size()]);
                this.subscriber.fireTeamResourceChange(deltas);
                monitor.worked(1);
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return UpdateUIJob.class.equals(family);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UpdateUIJob)) {
                return false;
            }
            UpdateUIJob job = (UpdateUIJob)((Object)obj);
            if (this.events.size() != job.events.size()) {
                return false;
            }
            if (!((Object)((Object)this.subscriber)).equals((Object)job.subscriber)) {
                return false;
            }
            return this.events.containsAll(job.events);
        }

        public int hashCode() {
            return this.events.size() + ((Object)((Object)this.subscriber)).hashCode();
        }
    }
}

