/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.repository.actions;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.repository.actions.HgAction;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionListenerAction;

public class RemoveRootAction
extends SelectionListenerAction {
    private IStructuredSelection selection;

    public RemoveRootAction(Shell shell) {
        super("Remove repository");
    }

    protected HgRepositoryLocation[] getSelectedRemoteRoots() {
        ArrayList<HgRepositoryLocation> resources = null;
        if (this.selection != null && !this.selection.isEmpty()) {
            resources = new ArrayList<HgRepositoryLocation>();
            Iterator elements = this.selection.iterator();
            while (elements.hasNext()) {
                Object next = HgAction.getAdapter(elements.next(), HgRepositoryLocation.class);
                if (!(next instanceof HgRepositoryLocation)) continue;
                resources.add((HgRepositoryLocation)next);
            }
        }
        if (resources != null && !resources.isEmpty()) {
            HgRepositoryLocation[] result = new HgRepositoryLocation[resources.size()];
            resources.toArray(result);
            return result;
        }
        return new HgRepositoryLocation[0];
    }

    protected String getErrorTitle() {
        return "Error";
    }

    public void run() {
        HgRepositoryLocation[] roots = this.getSelectedRemoteRoots();
        if (roots.length == 0) {
            return;
        }
        int i = 0;
        while (i < roots.length) {
            try {
                MercurialEclipsePlugin.getRepoManager().disposeRepository(roots[i]);
            }
            catch (CoreException e) {
                MercurialEclipsePlugin.logError(e);
            }
            ++i;
        }
    }

    protected boolean updateSelection(IStructuredSelection sel) {
        this.selection = sel;
        HgRepositoryLocation[] roots = this.getSelectedRemoteRoots();
        return roots.length > 0;
    }
}

