/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.repository.actions;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.repository.actions.ReplaceableIconAction;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public abstract class HgAction
extends ReplaceableIconAction {
    private List<IStatus> accumulatedStatus = new ArrayList<IStatus>();

    public final void run(IAction action) {
        try {
            if (!this.beginExecution(action)) {
                return;
            }
            this.execute(action);
            this.endExecution();
        }
        catch (InvocationTargetException e) {
            this.handle(e);
        }
        catch (InterruptedException interruptedException) {
            this.handle(null);
        }
    }

    protected boolean beginExecution(IAction action) {
        this.accumulatedStatus.clear();
        return true;
    }

    protected abstract void execute(IAction var1) throws InvocationTargetException, InterruptedException;

    protected void endExecution() {
        if (!this.accumulatedStatus.isEmpty()) {
            this.handle(null);
        }
    }

    protected void addStatus(IStatus status) {
        this.accumulatedStatus.add(status);
    }

    protected IStatus[] getAccumulatedStatus() {
        return this.accumulatedStatus.toArray(new IStatus[this.accumulatedStatus.size()]);
    }

    protected String getErrorTitle() {
        return "Error";
    }

    protected String getWarningTitle() {
        return "Warning";
    }

    protected String getMultiStatusMessage() {
        return "Multiple Problems occurred";
    }

    protected IStatus getStatusToDisplay(IStatus[] problems) {
        if (problems.length == 1) {
            return problems[0];
        }
        MultiStatus combinedStatus = new MultiStatus("com.vectrace.MercurialEclipse", 0, this.getMultiStatusMessage(), null);
        int i = 0;
        while (i < problems.length) {
            combinedStatus.merge(problems[i]);
            ++i;
        }
        return combinedStatus;
    }

    protected void handle(Exception exception) {
        ArrayList<IStatus> problems = new ArrayList<IStatus>();
        IStatus[] status = this.getAccumulatedStatus();
        if (status != null) {
            int i = 0;
            while (i < status.length) {
                IStatus iStatus = status[i];
                if (!iStatus.isOK()) {
                    problems.add(iStatus);
                }
                ++i;
            }
        }
        if (problems.size() == 0) {
            if (exception == null) {
                return;
            }
            this.handle(exception, this.getErrorTitle(), null);
            return;
        }
        if (exception != null) {
            this.handle(exception, this.getErrorTitle(), null);
        }
        String message = null;
        IStatus statusToDisplay = this.getStatusToDisplay(problems.toArray(new IStatus[problems.size()]));
        if (statusToDisplay.isOK()) {
            return;
        }
        if (statusToDisplay.isMultiStatus() && statusToDisplay.getChildren().length == 1) {
            message = statusToDisplay.getMessage();
            statusToDisplay = statusToDisplay.getChildren()[0];
        }
        String title = statusToDisplay.getSeverity() == 4 ? this.getErrorTitle() : this.getWarningTitle();
        MercurialEclipsePlugin.logError(String.valueOf(message) + "," + title, exception);
    }

    protected final void run(final IRunnableWithProgress runnable, boolean cancelable, int progressKind) throws InvocationTargetException, InterruptedException {
        final Exception[] exceptions = new Exception[1];
        final IRunnableWithProgress innerRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                runnable.run(monitor);
            }
        };
        switch (progressKind) {
            case 2: {
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                    public void run() {
                        try {
                            innerRunnable.run((IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (InvocationTargetException e) {
                            exceptions[0] = e;
                        }
                        catch (InterruptedException e) {
                            exceptions[0] = e;
                        }
                    }
                });
                break;
            }
            default: {
                new ProgressMonitorDialog(this.getShell()).run(true, cancelable, innerRunnable);
            }
        }
        if (exceptions[0] != null) {
            if (exceptions[0] instanceof InvocationTargetException) {
                throw (InvocationTargetException)exceptions[0];
            }
            throw (InterruptedException)exceptions[0];
        }
    }

    protected boolean needsToSaveDirtyEditors() {
        return false;
    }

    public static Object getAdapter(Object selection, Class c) {
        IAdaptable a;
        Object adapter;
        if (c.isInstance(selection)) {
            return selection;
        }
        if (selection instanceof IAdaptable && c.isInstance(adapter = (a = (IAdaptable)selection).getAdapter(c))) {
            return adapter;
        }
        return null;
    }

    protected void handle(Exception exception, String title, String message) {
        MercurialEclipsePlugin.logError(String.valueOf(title) + "," + message, exception);
    }
}

