/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.operations;

import com.vectrace.MercurialEclipse.actions.HgOperation;
import com.vectrace.MercurialEclipse.commands.extensions.HgRebaseClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.operations.Messages;
import com.vectrace.MercurialEclipse.team.cache.LocalChangesetCache;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;

public class RebaseOperation
extends HgOperation {
    private IResource res;
    private int sourceRev = -1;
    private int destRev = -1;
    private int baseRev = -1;
    private boolean collapse;
    private boolean abort;
    private boolean cont;

    public RebaseOperation(IRunnableContext context, IResource resource, int sourceRev, int destRev, int baseRev, boolean collapse, boolean abort, boolean cont) {
        super(context);
        this.res = resource;
        this.sourceRev = sourceRev;
        this.destRev = destRev;
        this.baseRev = baseRev;
        this.collapse = collapse;
        this.abort = abort;
        this.cont = cont;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask(this.getActionDescription(), 3);
        try {
            monitor.worked(1);
            monitor.subTask(Messages.getString("RebaseOperation.calling"));
            this.result = HgRebaseClient.rebase(this.res.getLocation().toFile(), this.sourceRev, this.baseRev, this.destRev, this.collapse, this.cont, this.abort);
            monitor.worked(1);
            monitor.subTask(Messages.getString("RebaseOperation.refreshing"));
            LocalChangesetCache.getInstance().refreshAllLocalRevisions(this.res, true);
            monitor.worked(1);
        }
        catch (HgException e) {
            throw new InvocationTargetException((Throwable)((Object)e), e.getLocalizedMessage());
        }
        monitor.done();
    }

    protected String getActionDescription() {
        return Messages.getString("RebaseOperation.rebasing");
    }
}

