/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.operations;

import com.vectrace.MercurialEclipse.actions.HgOperation;
import com.vectrace.MercurialEclipse.commands.HgCloneClient;
import com.vectrace.MercurialEclipse.commands.extensions.HgSvnClient;
import com.vectrace.MercurialEclipse.commands.extensions.forest.HgFcloneClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.wizards.Messages;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;

public class CloneOperation
extends HgOperation {
    private final String parentDirectory;
    private final HgRepositoryLocation repo;
    private final boolean noUpdate;
    private final boolean pull;
    private final boolean uncompressed;
    private final boolean timeout;
    private final String rev;
    private final String cloneName;
    private final boolean forest;
    private final boolean svn;

    public CloneOperation(IRunnableContext context, String parentDirectory, HgRepositoryLocation repo, boolean noUpdate, boolean pull, boolean uncompressed, boolean timeout, String rev, String cloneName, boolean forest, boolean svn) {
        super(context);
        this.parentDirectory = parentDirectory;
        this.repo = repo;
        this.noUpdate = noUpdate;
        this.pull = pull;
        this.uncompressed = uncompressed;
        this.timeout = timeout;
        this.rev = rev;
        this.cloneName = cloneName;
        this.forest = forest;
        this.svn = svn;
    }

    public void run(IProgressMonitor m) throws InvocationTargetException, InterruptedException {
        m.beginTask(Messages.getString("CloneRepoWizard.operation.name"), 50);
        m.subTask(String.valueOf(Messages.getString("CloneRepoWizard.subTaskParentDirectory.name")) + this.parentDirectory);
        m.worked(1);
        m.subTask(String.valueOf(Messages.getString("CloneRepoWizard.subTaskCloneDirectory.name")) + this.cloneName);
        m.worked(1);
        try {
            m.subTask(Messages.getString("CloneRepoWizard.subTask.invokingMercurial"));
            if (this.svn) {
                HgSvnClient.clone(new File(this.parentDirectory), this.repo, this.timeout, this.cloneName);
            } else if (!this.forest) {
                HgCloneClient.clone(this.parentDirectory, this.repo, this.noUpdate, this.pull, this.uncompressed, this.timeout, this.rev, this.cloneName);
            } else {
                HgFcloneClient.fclone(this.parentDirectory, this.repo, this.noUpdate, this.pull, this.uncompressed, this.timeout, this.rev, this.cloneName);
            }
            m.worked(1);
        }
        catch (HgException e) {
            throw new InvocationTargetException((Throwable)((Object)e));
        }
    }

    protected String getActionDescription() {
        return String.valueOf(Messages.getString("CloneRepoWizard.actionDescription.1")) + this.repo + Messages.getString("CloneRepoWizard.actionDescription.2") + this.cloneName;
    }

    public String getParentDirectory() {
        return this.parentDirectory;
    }
}

