/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.model;

import com.vectrace.MercurialEclipse.HgRevision;
import com.vectrace.MercurialEclipse.model.FileStatus;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.utils.ResourceUtils;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.compare.patch.IFilePatch;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeSet
implements Comparable<ChangeSet> {
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd hh:mm Z");
    public static final Date UNKNOWN_DATE = new Date(0L);
    private final HgRevision revision;
    private final int changesetIndex;
    private final String changeset;
    private final String branch;
    private final String user;
    private final String date;
    private String tag;
    private FileStatus[] changedFiles;
    private String description;
    private String ageDate;
    private String nodeShort;
    private String[] parents;
    private Date realDate;
    private File bundleFile;
    private HgRepositoryLocation repository;
    private Direction direction;
    private String summary;
    private final HgRoot hgRoot;
    private IFilePatch[] patches;

    private ChangeSet(int changesetIndex, String changeSet, String tag, String branch, String user, String date, String description, String[] parents, HgRoot root) {
        this.changesetIndex = changesetIndex;
        this.changeset = changeSet;
        this.revision = new HgRevision(this.changeset, changesetIndex);
        this.tag = tag;
        this.branch = branch;
        this.user = user;
        this.date = date;
        this.hgRoot = root;
        this.setDescription(description);
        this.setParents(parents);
    }

    private ChangeSet(int changesetIndex, String changeSet, String user, String date, String branch, HgRoot root) {
        this(changesetIndex, changeSet, null, branch, user, date, "", null, root);
    }

    public int getChangesetIndex() {
        return this.changesetIndex;
    }

    public String getChangeset() {
        return this.changeset;
    }

    public String getTag() {
        if ("tip".equals(this.tag) && this.bundleFile != null) {
            StringBuilder builder = new StringBuilder(this.tag).append(" [ ").append(this.repository.toString()).append(" ]");
            this.tag = builder.toString();
        }
        return this.tag;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getUser() {
        return this.user;
    }

    public String getDate() {
        return this.date;
    }

    public String getDescription() {
        return this.description;
    }

    public HgRevision getRevision() {
        return this.revision;
    }

    public String toString() {
        if (this.nodeShort != null) {
            return String.valueOf(this.changesetIndex) + ":" + this.nodeShort;
        }
        return String.valueOf(this.changesetIndex) + ":" + this.changeset;
    }

    public FileStatus[] getChangedFiles() {
        if (this.changedFiles != null) {
            return (FileStatus[])this.changedFiles.clone();
        }
        return new FileStatus[0];
    }

    public boolean isRemoved(IResource resource) {
        FileStatus.Action action = FileStatus.Action.REMOVED;
        return this.contains(resource, action);
    }

    public boolean isAdded(IResource resource) {
        FileStatus.Action action = FileStatus.Action.ADDED;
        return this.contains(resource, action);
    }

    public boolean isModified(IResource resource) {
        FileStatus.Action action = FileStatus.Action.MODIFIED;
        return this.contains(resource, action);
    }

    private boolean contains(IResource resource, FileStatus.Action action) {
        if (this.changedFiles.length == 0) {
            return false;
        }
        boolean match = false;
        Path path = new Path(this.hgRoot.toRelative(ResourceUtils.getFileHandle(resource)));
        FileStatus[] fileStatusArray = this.changedFiles;
        int n = this.changedFiles.length;
        int n2 = 0;
        while (n2 < n) {
            FileStatus fileStatus = fileStatusArray[n2];
            if (fileStatus.getAction() == action && path.equals((Object)new Path(fileStatus.getPath()))) {
                match = true;
                break;
            }
            ++n2;
        }
        return match;
    }

    public String getAgeDate() {
        return this.ageDate;
    }

    public String getNodeShort() {
        return this.nodeShort;
    }

    @Override
    public int compareTo(ChangeSet o) {
        if (o.getChangeset().equals(this.getChangeset())) {
            return 0;
        }
        int result = this.getChangesetIndex() - o.getChangesetIndex();
        if (result != 0) {
            return result;
        }
        if (this.getRealDate() != UNKNOWN_DATE && o.getRealDate() != UNKNOWN_DATE) {
            return this.getRealDate().compareTo(o.getRealDate());
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChangeSet) {
            ChangeSet other = (ChangeSet)obj;
            if (this.getChangeset().equals(other.getChangeset())) {
                return true;
            }
            if (this.date != null && this.date.equals(other.getDate())) {
                return true;
            }
            return this.getChangesetIndex() == other.getChangesetIndex();
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.changeset == null ? 0 : this.changeset.hashCode());
        return result;
    }

    public Date getRealDate() {
        try {
            if (this.realDate == null) {
                this.realDate = this.date != null ? SIMPLE_DATE_FORMAT.parse(this.date) : UNKNOWN_DATE;
            }
        }
        catch (ParseException parseException) {
            this.realDate = UNKNOWN_DATE;
        }
        return this.realDate;
    }

    public File getBundleFile() {
        return this.bundleFile;
    }

    public String[] getParents() {
        return this.parents;
    }

    private void setParents(String[] parents) {
        if (parents != null) {
            ArrayList<String> temp = new ArrayList<String>(parents.length);
            int i = 0;
            while (i < parents.length) {
                String parent = parents[i];
                if (parent.charAt(0) != '-') {
                    temp.add(parent);
                }
                ++i;
            }
            this.parents = temp.toArray(new String[temp.size()]);
        }
    }

    private void setDescription(String description) {
        if (description != null) {
            int i = description.indexOf(10);
            this.summary = i > 0 ? description.substring(0, i >= 0 ? i : description.length()) : description;
            this.description = description;
        }
    }

    public String getSummary() {
        return this.summary;
    }

    public HgRepositoryLocation getRepository() {
        return this.repository;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public HgRoot getHgRoot() {
        return this.hgRoot;
    }

    public IFilePatch[] getPatches() {
        return this.patches;
    }

    /* synthetic */ ChangeSet(int n, String string, String string2, String string3, String string4, HgRoot hgRoot, ChangeSet changeSet) {
        this(n, string, string2, string3, string4, hgRoot);
    }

    public static class Builder {
        private ChangeSet cs;

        public Builder(int revision, String changeSet, String branch, String date, String user, HgRoot root) {
            this.cs = new ChangeSet(revision, changeSet, user, date, branch == null ? "" : branch, root, null);
        }

        public Builder tag(String tag) {
            this.cs.tag = tag;
            return this;
        }

        public Builder description(String description) {
            this.cs.setDescription(description);
            return this;
        }

        public Builder parents(String[] parents) {
            this.cs.setParents(parents);
            return this;
        }

        public Builder direction(Direction direction) {
            this.cs.direction = direction;
            return this;
        }

        public Builder changedFiles(FileStatus[] changedFiles) {
            this.cs.changedFiles = changedFiles;
            return this;
        }

        public Builder bundleFile(File bundleFile) {
            this.cs.bundleFile = bundleFile;
            return this;
        }

        public Builder repository(HgRepositoryLocation repository) {
            this.cs.repository = repository;
            return this;
        }

        public Builder ageDate(String ageDate) {
            this.cs.ageDate = ageDate;
            return this;
        }

        public Builder nodeShort(String nodeShort) {
            this.cs.nodeShort = nodeShort;
            return this;
        }

        public void patches(IFilePatch[] patches) {
            this.cs.patches = patches;
        }

        public ChangeSet build() {
            ChangeSet result = this.cs;
            this.cs = null;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        INCOMING,
        OUTGOING,
        LOCAL;

    }
}

