/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.model;

public class Bookmark {
    private final String name;
    private final int revision;
    private final String shortNode;
    private final boolean active;

    public Bookmark(String name, int revision, String globalId, boolean active) {
        this.name = name;
        this.revision = revision;
        this.shortNode = globalId;
        this.active = active;
    }

    public Bookmark(String line) {
        assert (line != null && line.length() > 0);
        assert (!line.startsWith("no bookmarks set"));
        this.active = line.startsWith(" *");
        int lastSpace = line.lastIndexOf(" ");
        this.name = line.substring(3, lastSpace).trim();
        int colon = line.lastIndexOf(":");
        this.revision = Integer.parseInt(line.substring(lastSpace + 1, colon));
        this.shortNode = line.substring(colon + 1);
    }

    public String getName() {
        return this.name;
    }

    public int getRevision() {
        return this.revision;
    }

    public String getShortNodeId() {
        return this.shortNode;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bookmark other = (Bookmark)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public boolean isActive() {
        return this.active;
    }
}

