/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.menu;

import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.menu.Messages;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.team.MercurialTeamProvider;
import com.vectrace.MercurialEclipse.utils.ResourceUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultipleResourcesHandler
extends AbstractHandler {
    private List<IResource> selection;

    protected Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    protected List<IResource> getSelectedResources() {
        return this.selection;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object selectionObject = ((EvaluationContext)event.getApplicationContext()).getDefaultVariable();
        this.selection = new ArrayList<IResource>();
        if (selectionObject != null && selectionObject instanceof List) {
            List list = (List)selectionObject;
            for (Object listEntry : list) {
                if (listEntry == null || !(listEntry instanceof IAdaptable)) continue;
                IAdaptable selectionAdaptable = (IAdaptable)listEntry;
                this.selection.add((IResource)selectionAdaptable.getAdapter(IResource.class));
            }
        }
        if (this.selection.size() == 0) {
            this.selection.add(ResourceUtils.getActiveResourceFromEditor());
        }
        try {
            this.run(this.getSelectedResources());
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("MultipleResourcesHandler.hgSays"), (String)(String.valueOf(e.getMessage()) + Messages.getString("MultipleResourcesHandler.seeErrorLog")));
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected HgRoot ensureSameRoot(List<IResource> resources) throws HgException {
        HgRoot root = MercurialTeamProvider.getHgRoot(resources.get(0));
        for (IResource res : resources) {
            if (root.equals(MercurialTeamProvider.getHgRoot(res))) continue;
            throw new HgException(Messages.getString("MultipleResourcesHandler.allResourcesMustBeInSameProject"));
        }
        return root;
    }

    protected abstract void run(List<IResource> var1) throws Exception;
}

