/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.menu;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgClients;
import com.vectrace.MercurialEclipse.commands.HgMergeClient;
import com.vectrace.MercurialEclipse.commands.HgResolveClient;
import com.vectrace.MercurialEclipse.commands.extensions.HgIMergeClient;
import com.vectrace.MercurialEclipse.dialogs.RevisionChooserDialog;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.menu.CommitMergeHandler;
import com.vectrace.MercurialEclipse.menu.Messages;
import com.vectrace.MercurialEclipse.menu.SingleResourceHandler;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.model.FlaggedAdaptable;
import com.vectrace.MercurialEclipse.storage.DataLoader;
import com.vectrace.MercurialEclipse.storage.ProjectDataLoader;
import com.vectrace.MercurialEclipse.team.ResourceProperties;
import com.vectrace.MercurialEclipse.team.cache.LocalChangesetCache;
import com.vectrace.MercurialEclipse.views.MergeView;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class MergeHandler
extends SingleResourceHandler {
    protected void run(IResource resource) throws Exception {
        MergeHandler.merge(resource.getProject(), this.getShell(), (IProgressMonitor)new NullProgressMonitor(), false, true);
    }

    public static String merge(IProject project, Shell shell, IProgressMonitor monitor, boolean autoPickOtherHead, boolean showCommitDialog) throws HgException, CoreException {
        ProjectDataLoader loader = new ProjectDataLoader(project);
        ChangeSet cs = MergeHandler.getOtherHeadInCurrentBranch(project, loader);
        if (cs != null && !autoPickOtherHead) {
            MessageBox mb = new MessageBox(shell, 196);
            mb.setText("Merge");
            String csSummary = "Changeset: " + cs.getRevision().toString().substring(0, 20) + "\n" + "User: " + cs.getUser() + "\n" + "Date: " + cs.getDate() + "\n" + "Summary: " + cs.getSummary();
            String branch = cs.getBranch();
            if (branch.equals("")) {
                branch = "default";
            }
            mb.setMessage(MessageFormat.format(Messages.getString("MergeHandler.mergeWithOtherHead"), branch, csSummary));
            if (mb.open() == 128) {
                cs = null;
            }
        }
        while (cs == null) {
            RevisionChooserDialog dialog = new RevisionChooserDialog(shell, Messages.getString("MergeHandler.mergeWith"), loader);
            dialog.setDefaultShowingHeads(true);
            dialog.setDisallowSelectingParents(true);
            if (dialog.open() != 0) {
                return "";
            }
            cs = dialog.getChangeSet();
        }
        boolean useExternalMergeTool = Boolean.valueOf(HgClients.getPreference("hg.merge.useExternal", "false"));
        String result = "";
        boolean useResolve = MergeHandler.isHgResolveAvailable();
        result = useResolve ? HgMergeClient.merge((IResource)project, cs.getRevision().getChangeset(), useExternalMergeTool) : HgIMergeClient.merge(project, cs.getRevision().getChangeset());
        project.setPersistentProperty(ResourceProperties.MERGING, cs.getChangeset());
        try {
            result = String.valueOf(result) + MergeHandler.commitMerge(monitor, project, shell, result, showCommitDialog);
        }
        catch (CoreException e) {
            MercurialEclipsePlugin.logError(e);
            MercurialEclipsePlugin.showError(e);
        }
        project.touch((IProgressMonitor)new NullProgressMonitor());
        project.refreshLocal(2, null);
        return result;
    }

    private static String commitMerge(IProgressMonitor monitor, IProject project, Shell shell, String mergeResult, boolean showCommitDialog) throws CoreException {
        boolean commit = true;
        String output = "";
        if (!HgResolveClient.checkAvailable()) {
            if (!mergeResult.contains("all conflicts resolved")) {
                commit = false;
            }
        } else {
            List<FlaggedAdaptable> mergeAdaptables = HgResolveClient.list((IResource)project);
            monitor.subTask(com.vectrace.MercurialEclipse.wizards.Messages.getString("PullRepoWizard.pullOperation.mergeStatus"));
            for (FlaggedAdaptable flaggedAdaptable : mergeAdaptables) {
                if (flaggedAdaptable.getFlag() != 'U') continue;
                commit = false;
                break;
            }
            monitor.worked(1);
        }
        if (commit) {
            monitor.subTask(com.vectrace.MercurialEclipse.wizards.Messages.getString("PullRepoWizard.pullOperation.commit"));
            output = String.valueOf(output) + com.vectrace.MercurialEclipse.wizards.Messages.getString("PullRepoWizard.pullOperation.commit.header");
            output = !showCommitDialog ? String.valueOf(output) + CommitMergeHandler.commitMerge(project) : String.valueOf(output) + new CommitMergeHandler().commitMergeWithCommitDialog(project, shell);
            monitor.worked(1);
        } else {
            MergeView view = (MergeView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(MergeView.ID);
            view.clearView();
            view.setCurrentProject(project);
        }
        return output;
    }

    private static ChangeSet getOtherHeadInCurrentBranch(IProject project, DataLoader loader) throws HgException {
        ChangeSet[] heads = loader.getHeads();
        if (heads.length < 2) {
            return null;
        }
        ChangeSet currentRevision = LocalChangesetCache.getInstance().getCurrentWorkDirChangeset((IResource)project);
        String branch = currentRevision.getBranch();
        ChangeSet candidate = null;
        ChangeSet[] changeSetArray = heads;
        int n = heads.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeSet cs = changeSetArray[n2];
            if (cs.getBranch().equals(branch) && !cs.equals(currentRevision)) {
                if (candidate != null) {
                    return null;
                }
                candidate = cs;
            }
            ++n2;
        }
        return candidate;
    }

    private static boolean isHgResolveAvailable() throws HgException {
        return HgResolveClient.checkAvailable();
    }
}

