/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.menu;

import com.vectrace.MercurialEclipse.commands.HgAddClient;
import com.vectrace.MercurialEclipse.commands.HgStatusClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.menu.Messages;
import com.vectrace.MercurialEclipse.menu.MultipleResourcesHandler;
import com.vectrace.MercurialEclipse.team.cache.RefreshStatusJob;
import com.vectrace.MercurialEclipse.ui.ResourcesTreeContentProvider;
import com.vectrace.MercurialEclipse.ui.UntrackedResourcesFilter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddHandler
extends MultipleResourcesHandler {
    @Override
    protected void run(List<IResource> resources) throws HgException {
        Set<IProject> roots = this.getRoots(resources);
        HashMap<IProject, Set<IPath>> untrackedFiles = new HashMap<IProject, Set<IPath>>();
        HashMap<IProject, Set<IPath>> untrackedFolders = new HashMap<IProject, Set<IPath>>();
        for (IProject project : roots) {
            String[] rawFiles = HgStatusClient.getUntrackedFiles((IContainer)project);
            HashSet<Path> files = new HashSet<Path>();
            HashSet<IPath> folders = new HashSet<IPath>();
            String[] stringArray = rawFiles;
            int n = rawFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String raw = stringArray[n2];
                Path path = new Path(raw);
                files.add(path);
                int count = path.segmentCount();
                int i = 1;
                while (i < count) {
                    folders.add(path.removeLastSegments(i));
                    ++i;
                }
                ++n2;
            }
            untrackedFiles.put(project, files);
            untrackedFolders.put(project, folders);
        }
        UntrackedResourcesFilter untrackedFilter = new UntrackedResourcesFilter(untrackedFiles, untrackedFolders);
        CheckedTreeSelectionDialog dialog = new CheckedTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new ResourcesTreeContentProvider(roots));
        dialog.setInput(ResourcesTreeContentProvider.ROOT);
        dialog.setTitle(Messages.getString("AddHandler.addToVersionControl"));
        dialog.setMessage(Messages.getString("AddHandler.selectFiles"));
        dialog.setContainerMode(true);
        dialog.setInitialElementSelections(resources);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.addFilter((ViewerFilter)untrackedFilter);
        HashSet<IContainer> expanded = new HashSet<IContainer>();
        block3: for (IResource resource : resources) {
            IContainer parent = resource.getParent();
            while (parent != null && !expanded.contains(parent)) {
                if (parent.getType() == 8) continue block3;
                expanded.add(parent);
                parent = parent.getParent();
            }
        }
        dialog.setExpandedElements((Object[])expanded.toArray(new IContainer[0]));
        if (dialog.open() == 0) {
            HgAddClient.addResources(this.keepFiles(dialog.getResult()), null);
            for (IProject proj : roots) {
                new RefreshStatusJob(Messages.getString("AddHandler.refreshStatus"), proj).schedule();
            }
        }
    }

    private List<IResource> keepFiles(Object[] objects) {
        ArrayList<IResource> files = new ArrayList<IResource>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof IFile) {
                files.add((IResource)((IFile)object));
            }
            ++n2;
        }
        return files;
    }

    private Set<IProject> getRoots(List<IResource> resources) {
        TreeSet<IProject> roots = new TreeSet<IProject>(new Comparator<IProject>(){

            @Override
            public int compare(IProject p1, IProject p2) {
                return p1.getName().compareTo(p2.getName());
            }
        });
        for (IResource resource : resources) {
            roots.add(resource.getProject());
        }
        return roots;
    }
}

