/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.dialogs;

import com.vectrace.MercurialEclipse.dialogs.Messages;
import com.vectrace.MercurialEclipse.ui.CommitFilesChooser;
import com.vectrace.MercurialEclipse.ui.SWTWidgetHelper;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevertDialog
extends TitleAreaDialog {
    private List<IResource> resources;
    private CommitFilesChooser selectFilesList;
    private List<IResource> selection;
    private List<IResource> untrackedSelection;
    public static final String FILE_MODIFIED = Messages.getString("CommitDialog.modified");
    public static final String FILE_ADDED = Messages.getString("CommitDialog.added");
    public static final String FILE_REMOVED = Messages.getString("CommitDialog.removed");
    public static final String FILE_UNTRACKED = Messages.getString("CommitDialog.untracked");
    public static final String FILE_DELETED = Messages.getString("CommitDialog.deletedInWorkspace");

    public RevertDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = SWTWidgetHelper.createComposite(parent, 1);
        GridData gd = SWTWidgetHelper.getFillGD(400);
        container.setLayoutData((Object)gd);
        super.createDialogArea(parent);
        this.createFilesList(container);
        this.setTitle(Messages.getString("RevertDialog.title"));
        this.setMessage(Messages.getString("RevertDialog.message"));
        return container;
    }

    private void createFilesList(Composite container) {
        this.selectFilesList = new CommitFilesChooser(container, true, this.resources, true, true);
    }

    public void setFiles(List<IResource> resources) {
        this.resources = resources;
    }

    protected void okPressed() {
        boolean confirm;
        this.selection = this.selectFilesList.getCheckedResources(FILE_ADDED, FILE_DELETED, FILE_MODIFIED, FILE_REMOVED);
        this.untrackedSelection = this.selectFilesList.getCheckedResources(FILE_UNTRACKED);
        if (!this.untrackedSelection.isEmpty() && !(confirm = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Please confirm delete", (String)"You have selected to revert untracked files.\nThis files will be now deleted.\n\nContinue?"))) {
            return;
        }
        super.okPressed();
    }

    public void setFiles(IResource[] commitResources) {
        this.setFiles(Arrays.asList(commitResources));
    }

    public List<IResource> getSelectionForHgRevert() {
        return this.selection;
    }

    public List<IResource> getUntrackedSelection() {
        return this.untrackedSelection;
    }
}

