/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.dialogs;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.actions.StatusContainerAction;
import com.vectrace.MercurialEclipse.dialogs.CommitResource;
import com.vectrace.MercurialEclipse.dialogs.Messages;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.HgRoot;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.Team;

public final class CommitResourceUtil {
    private HgRoot root;

    public CommitResource[] getCommitResources(IResource[] inResources) throws HgException {
        StatusContainerAction statusAction = new StatusContainerAction(null, inResources);
        this.root = statusAction.getHgWorkingDir();
        try {
            statusAction.run();
            String result = statusAction.getResult();
            return this.spliceList(result, inResources);
        }
        catch (Exception e) {
            String msg = "HgRoot: " + this.root.getAbsolutePath() + Messages.getString("CommitResourceUtil.error.unableToGetStatus") + e.getMessage();
            MercurialEclipsePlugin.logError(msg, e);
            return null;
        }
    }

    private CommitResource[] spliceList(String string, IResource[] inResources) {
        ArrayList<CommitResource> list = new ArrayList<CommitResource>();
        StringTokenizer st = new StringTokenizer(string);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        while (st.hasMoreTokens()) {
            String status = st.nextToken(" ").trim();
            String fileName = st.nextToken("\n").trim();
            Path path = new Path(new File(this.root, fileName).getAbsolutePath());
            IFile statusResource = workspaceRoot.getFileForLocation((IPath)path);
            if (Team.isIgnoredHint((IResource)statusResource)) continue;
            list.add(new CommitResource(status, (IResource)statusResource, new File(fileName)));
        }
        return list.toArray(new CommitResource[0]);
    }
}

