/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands.extensions;

import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.team.cache.RefreshJob;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class HgSvnClient
extends AbstractClient {
    public static String pull(IResource resource) throws HgException {
        HgCommand cmd = new HgCommand("svn", HgSvnClient.getWorkingDirectory(resource.getLocation().toFile()), false);
        cmd.setUsePreferenceTimeout("hg.timeout.pull");
        cmd.addOptions("pull");
        String result = cmd.executeToString();
        IProject project = resource.getProject();
        new RefreshJob("Refreshing " + project.getName(), project, 7).schedule();
        return result;
    }

    public static String push(File currentWorkingDirectory) throws HgException {
        HgCommand cmd = new HgCommand("svn", HgSvnClient.getWorkingDirectory(currentWorkingDirectory), false);
        cmd.setUsePreferenceTimeout("hg.timeout.push");
        cmd.addOptions("push");
        return cmd.executeToString();
    }

    public static String rebase(IResource resource) throws HgException {
        HgCommand cmd = new HgCommand("svn", HgSvnClient.getWorkingDirectory(resource.getLocation().toFile()), false);
        cmd.setUsePreferenceTimeout("hg.timeout.push");
        cmd.addOptions("--config", "extensions.hgext.rebase=");
        cmd.addOptions("rebase");
        String result = cmd.executeToString();
        IProject project = resource.getProject();
        new RefreshJob("Refreshing " + project.getName(), project, 1).schedule();
        return result;
    }

    public static void clone(File currentWorkingDirectory, HgRepositoryLocation repo, boolean timeout, String cloneName) throws HgException {
        HgCommand cmd = new HgCommand("svnclone", HgSvnClient.getWorkingDirectory(currentWorkingDirectory), false);
        cmd.setUsePreferenceTimeout("hg.timeout.clone");
        HgSvnClient.addRepoToHgCommand(repo, cmd);
        if (cloneName != null) {
            cmd.addOptions(cloneName);
        }
        if (timeout) {
            cmd.setUsePreferenceTimeout("hg.timeout.clone");
            cmd.executeToBytes();
        } else {
            cmd.executeToBytes(Integer.MAX_VALUE);
        }
    }
}

