/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands.extensions;

import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.team.cache.RefreshJob;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;

public class HgStripClient {
    public static String strip(IProject proj, boolean saveUnrelated, boolean backup, boolean stripHeads, ChangeSet changeset) throws HgException {
        HgCommand command = new HgCommand("strip", (IContainer)proj, true);
        command.setUsePreferenceTimeout("hg.timeout.commit");
        command.addOptions("--config", "extensions.hgext.mq=");
        if (saveUnrelated) {
            command.addOptions("--backup");
        }
        if (!backup) {
            command.addOptions("--nobackup");
        }
        if (stripHeads) {
            command.addOptions("-f");
        }
        command.addOptions(changeset.getChangeset());
        String result = command.executeToString();
        new RefreshJob("Refreshing hg caches", proj).schedule();
        return result;
    }
}

