/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands.extensions;

import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.Bookmark;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HgBookmarkClient
extends AbstractClient {
    public static List<Bookmark> getBookmarks(File file) throws HgException {
        HgCommand cmd = new HgCommand("bookmarks", HgBookmarkClient.getWorkingDirectory(file), true);
        cmd.addOptions("--config", "extensions.hgext.bookmarks=");
        String result = cmd.executeToString();
        ArrayList<Bookmark> bookmarks = HgBookmarkClient.convert(result);
        return bookmarks;
    }

    private static ArrayList<Bookmark> convert(String result) {
        ArrayList<Bookmark> bookmarks = new ArrayList<Bookmark>();
        if (!result.startsWith("no bookmarks set")) {
            String[] split;
            String[] stringArray = split = result.split("\n");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                bookmarks.add(new Bookmark(string));
                ++n2;
            }
        }
        return bookmarks;
    }

    public static String create(File file, String name, String targetChangeset) throws HgException {
        HgCommand cmd = new HgCommand("bookmarks", HgBookmarkClient.getWorkingDirectory(file), true);
        cmd.addOptions("--config", "extensions.hgext.bookmarks=");
        cmd.addOptions("--rev", targetChangeset, name);
        String result = cmd.executeToString();
        return result;
    }

    public static String rename(File file, String name, String newName) throws HgException {
        HgCommand cmd = new HgCommand("bookmarks", HgBookmarkClient.getWorkingDirectory(file), true);
        cmd.addOptions("--config", "extensions.hgext.bookmarks=");
        cmd.addOptions("--rename", name, newName);
        String result = cmd.executeToString();
        return result;
    }

    public static String delete(File file, String name) throws HgException {
        HgCommand cmd = new HgCommand("bookmarks", HgBookmarkClient.getWorkingDirectory(file), true);
        cmd.addOptions("--config", "extensions.hgext.bookmarks=");
        cmd.addOptions("--delete", name);
        String result = cmd.executeToString();
        return result;
    }
}

