/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.commands.HgClients;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.FlaggedAdaptable;
import com.vectrace.MercurialEclipse.team.ResourceProperties;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HgResolveClient
extends AbstractClient {
    public static List<FlaggedAdaptable> list(IResource res) throws HgException {
        HgCommand command = new HgCommand("resolve", HgResolveClient.getWorkingDirectory(res), false);
        command.setUsePreferenceTimeout("hg.timeout.imerge");
        command.addOptions("-l");
        String[] lines = command.executeToString().split("\n");
        ArrayList<FlaggedAdaptable> result = new ArrayList<FlaggedAdaptable>();
        if (lines.length != 1 || !"".equals(lines[0])) {
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                IFile iFile = res.getProject().getFile(line.substring(2));
                FlaggedAdaptable fa = new FlaggedAdaptable((IAdaptable)iFile, line.charAt(0));
                result.add(fa);
                ++n2;
            }
        }
        return result;
    }

    public static String markResolved(IFile ifile) throws HgException {
        File file = ifile.getLocation().toFile();
        try {
            HgCommand command = new HgCommand("resolve", HgResolveClient.getWorkingDirectory(file), false);
            command.setUsePreferenceTimeout("hg.timeout.imerge");
            command.addOptions("-m", file.getCanonicalPath());
            String result = command.executeToString();
            HgResolveClient.refreshStatus((IResource)ifile);
            return result;
        }
        catch (IOException e) {
            throw new HgException(e.getLocalizedMessage(), e);
        }
    }

    public static String resolveAll(IResource res) throws HgException {
        File file = res.getLocation().toFile();
        HgCommand command = new HgCommand("resolve", HgResolveClient.getWorkingDirectory(file), false);
        boolean useExternalMergeTool = Boolean.valueOf(HgClients.getPreference("hg.merge.useExternal", "false"));
        if (!useExternalMergeTool) {
            command.addOptions("--config", "ui.merge=simplemerge");
        }
        command.setUsePreferenceTimeout("hg.timeout.imerge");
        String result = command.executeToString();
        HgResolveClient.refreshStatus(res);
        return result;
    }

    public static String markUnresolved(IFile ifile) throws HgException {
        File file = ifile.getLocation().toFile();
        try {
            HgCommand command = new HgCommand("resolve", HgResolveClient.getWorkingDirectory(file), false);
            command.setUsePreferenceTimeout("hg.timeout.imerge");
            command.addOptions("-u", file.getCanonicalPath());
            String result = command.executeToString();
            HgResolveClient.refreshStatus((IResource)ifile);
            return result;
        }
        catch (IOException e) {
            throw new HgException(e.getLocalizedMessage(), e);
        }
    }

    private static void refreshStatus(IResource res) throws HgException {
        MercurialStatusCache.getInstance().refreshStatus(res, null);
        try {
            res.touch(null);
        }
        catch (CoreException e) {
            MercurialEclipsePlugin.logError(e);
        }
    }

    public static boolean checkAvailable() throws HgException {
        try {
            boolean returnValue;
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            Object prop = workspaceRoot.getSessionProperty(ResourceProperties.RESOLVE_AVAILABLE);
            if (prop != null) {
                boolean useResolve;
                returnValue = useResolve = ((Boolean)prop).booleanValue();
            } else {
                HgCommand command = new HgCommand("help", (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false);
                command.addOptions("resolve");
                try {
                    String result = new String(command.executeToBytes(10000, false));
                    returnValue = !result.startsWith("hg: unknown command 'resolve'");
                }
                catch (HgException hgException) {
                    returnValue = false;
                }
                workspaceRoot.setSessionProperty(ResourceProperties.RESOLVE_AVAILABLE, (Object)returnValue);
            }
            return returnValue;
        }
        catch (CoreException e) {
            throw new HgException(e);
        }
    }
}

