/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.commands.RefreshWorkspaceStatusJob;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.team.cache.RefreshJob;
import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class HgPushPullClient
extends AbstractClient {
    public static String push(IProject project, HgRepositoryLocation repo, boolean force, String revision, int timeout) throws HgException {
        HgCommand command = new HgCommand("push", (IContainer)project, true);
        command.setUsePreferenceTimeout("hg.timeout.push");
        if (force) {
            command.addOptions("-f");
        }
        if (revision != null && revision.length() > 0) {
            command.addOptions("-r", revision.trim());
        }
        HgPushPullClient.addRepoToHgCommand(repo, command);
        return new String(command.executeToBytes(timeout));
    }

    public static String pull(IProject project, HgRepositoryLocation location, boolean update) throws HgException {
        return HgPushPullClient.pull(project, null, location, update, false, false, false);
    }

    public static String pull(IProject project, ChangeSet changeset, HgRepositoryLocation repo, boolean update, boolean rebase, boolean force, boolean timeout) throws HgException {
        URI uri = repo.getUri();
        String pullSource = uri != null ? uri.toASCIIString() : repo.getLocation();
        return HgPushPullClient.pull(project, changeset, pullSource, update, rebase, force, timeout);
    }

    public static String pull(final IProject project, ChangeSet changeset, String pullSource, boolean update, boolean rebase, boolean force, boolean timeout) throws HgException {
        String result;
        HgCommand command = new HgCommand("pull", project.getLocation().toFile(), true);
        if (update) {
            command.addOptions("--update");
        } else if (rebase) {
            command.addOptions("--config", "extensions.hgext.rebase=");
            command.addOptions("--rebase");
        }
        if (force) {
            command.addOptions("--force");
        }
        if (changeset != null) {
            command.addOptions("--rev", changeset.getChangeset());
        }
        command.addOptions(pullSource);
        if (timeout) {
            command.setUsePreferenceTimeout("hg.timeout.pull");
            result = new String(command.executeToBytes());
        } else {
            result = new String(command.executeToBytes(Integer.MAX_VALUE));
        }
        if (update) {
            RefreshWorkspaceStatusJob job = new RefreshWorkspaceStatusJob(project);
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    new RefreshJob("Refreshing " + project.getName(), project, 7).schedule();
                }
            });
            job.schedule();
        } else {
            new RefreshJob("Refreshing " + project.getName(), project, 7).schedule();
        }
        return result;
    }
}

