/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.commands.AbstractParseChangesetClient;
import com.vectrace.MercurialEclipse.commands.AbstractShellCommand;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.commands.HgStatusClient;
import com.vectrace.MercurialEclipse.commands.Messages;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.history.MercurialHistory;
import com.vectrace.MercurialEclipse.history.MercurialRevision;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.team.MercurialTeamProvider;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.compare.patch.IFilePatch;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HgLogClient
extends AbstractParseChangesetClient {
    private static final Pattern GET_REVISIONS_PATTERN = Pattern.compile("^([0-9]+):([a-f0-9]+) ([^ ]+ [^ ]+ [^ ]+) ([^#]+)#(.*)\\*\\*#(.*)$");
    public static final String NOLIMIT = "999999999999";

    public static ChangeSet[] getHeads(IProject project) throws HgException {
        HgCommand command = new HgCommand("heads", (IContainer)project, true);
        command.setUsePreferenceTimeout("hg.timeout.log");
        return HgLogClient.getRevisions(command);
    }

    private static ChangeSet[] getRevisions(HgCommand command) throws HgException {
        command.addOptions("--template", "{rev}:{node} {date|isodate} {author|person}#{branches}**#{desc|firstline}\n");
        command.setUsePreferenceTimeout("hg.timeout.log");
        String[] lines = null;
        try {
            lines = command.executeToString().split("\n");
        }
        catch (HgException e) {
            if (!e.getMessage().contains("abort: can only follow copies/renames for explicit file names")) {
                throw new HgException((CoreException)((Object)e));
            }
            return null;
        }
        int length = lines.length;
        ChangeSet[] changeSets = new ChangeSet[length];
        HgRoot root = command.getHgRoot();
        int i = 0;
        while (i < length) {
            ChangeSet changeSet;
            Matcher m = GET_REVISIONS_PATTERN.matcher(lines[i]);
            if (!m.matches()) {
                throw new HgException(String.valueOf(Messages.getString("HgLogClient.parseException")) + lines[i] + "'");
            }
            changeSets[i] = changeSet = new ChangeSet.Builder(Integer.parseInt(m.group(1)), m.group(2), m.group(5), m.group(3), m.group(4), root).description(m.group(6)).build();
            ++i;
        }
        return changeSets;
    }

    public static Map<IPath, SortedSet<ChangeSet>> getCompleteProjectLog(IResource res, boolean withFiles) throws HgException {
        return HgLogClient.getProjectLog(res, -1, -1, withFiles);
    }

    public static Map<IPath, SortedSet<ChangeSet>> getProjectLogBatch(IResource res, int batchSize, int startRev, boolean withFiles) throws HgException {
        return HgLogClient.getProjectLog(res, batchSize, startRev, withFiles);
    }

    public static Map<IPath, SortedSet<ChangeSet>> getRecentProjectLog(IResource res, int limitNumber, boolean withFiles) throws HgException {
        return HgLogClient.getProjectLogBatch(res, limitNumber, -1, withFiles);
    }

    public static Map<IPath, SortedSet<ChangeSet>> getProjectLog(IResource res, int limitNumber, int startRev, boolean withFiles) throws HgException {
        String result;
        block5: {
            try {
                HgCommand command = new HgCommand("log", HgLogClient.getWorkingDirectory(res), false);
                command.setUsePreferenceTimeout("hg.timeout.log");
                command.addOptions("--debug", "--style", AbstractParseChangesetClient.getStyleFile(withFiles).getCanonicalPath());
                HgLogClient.addRange(command, startRev, limitNumber);
                if (res.getType() == 1) {
                    command.addOptions("-f");
                }
                if (res.getType() != 4) {
                    command.addOptions(res.getLocation().toOSString());
                }
                if ((result = command.executeToString()).length() != 0) break block5;
                return null;
            }
            catch (IOException e) {
                throw new HgException(e.getLocalizedMessage(), e);
            }
        }
        Map<IPath, SortedSet<ChangeSet>> revisions = HgLogClient.createMercurialRevisions(res, result, withFiles, ChangeSet.Direction.LOCAL, null, null, new IFilePatch[0]);
        return revisions;
    }

    public static Map<IPath, SortedSet<ChangeSet>> getPathLog(boolean isFile, File path, HgRoot root, int limitNumber, int startRev, boolean withFiles) throws HgException {
        String result;
        block4: {
            try {
                HgCommand command = new HgCommand("log", (File)root, false);
                command.setUsePreferenceTimeout("hg.timeout.log");
                command.addOptions("--debug", "--style", AbstractParseChangesetClient.getStyleFile(withFiles).getCanonicalPath());
                HgLogClient.addRange(command, startRev, limitNumber);
                if (isFile) {
                    command.addOptions("-f");
                }
                command.addOptions(root.toRelative(path));
                result = command.executeToString();
                if (result.length() != 0) break block4;
                return null;
            }
            catch (IOException e) {
                throw new HgException(e.getLocalizedMessage(), e);
            }
        }
        Map<IPath, SortedSet<ChangeSet>> revisions = HgLogClient.createMercurialRevisions((IPath)new Path(path.getAbsolutePath()), result, ChangeSet.Direction.LOCAL, null, null, new IFilePatch[0], root);
        return revisions;
    }

    public static void addRange(AbstractShellCommand command, int startRev, int limitNumber) {
        if (startRev >= 0 && startRev != Integer.MAX_VALUE) {
            int last = Math.max(startRev - limitNumber, 0);
            command.addOptions("-r");
            command.addOptions(String.valueOf(startRev) + ":" + last);
        }
        HgLogClient.setLimit(command, limitNumber);
    }

    public static void setLimit(AbstractShellCommand command, int limitNumber) {
        command.addOptions("--limit", limitNumber > 0 ? String.valueOf(limitNumber) : NOLIMIT);
    }

    public static ChangeSet getLogWithBranchInfo(MercurialRevision rev, int limitNumber, MercurialHistory history) throws HgException {
        ChangeSet changeSet = rev.getChangeSet();
        Map<IPath, SortedSet<ChangeSet>> map = HgLogClient.getProjectLog(rev.getResource(), limitNumber, changeSet.getChangesetIndex(), true);
        if (map != null) {
            return map.get(rev.getResource().getLocation()).first();
        }
        File possibleParent = rev.getParent();
        MercurialRevision next = rev;
        if (possibleParent == null) {
            while ((next = history.getNext(next)) != null) {
                if (next.getParent() == null) {
                    possibleParent = HgStatusClient.getPossibleSourcePath(changeSet.getHgRoot(), next.getResource().getLocation().toFile(), next.getRevision());
                    if (possibleParent == null) continue;
                    break;
                }
                possibleParent = next.getParent();
                break;
            }
            if (possibleParent != null) {
                while ((next = history.getPrev(next)) != rev) {
                    if (next == null) break;
                    next.setParent(possibleParent);
                }
            }
        }
        if (possibleParent != null) {
            rev.setParent(possibleParent);
            map = HgLogClient.getPathLog(rev.getResource().getType() == 1, possibleParent, MercurialTeamProvider.getHgRoot(rev.getResource()), limitNumber, rev.getRevision(), true);
            if (map != null) {
                return map.get(new Path(possibleParent.getAbsolutePath())).first();
            }
        }
        return null;
    }

    public static ChangeSet getChangeset(IResource res, String nodeId, boolean withFiles) throws HgException {
        try {
            Assert.isNotNull((Object)nodeId);
            HgCommand command = new HgCommand("log", res.getProject().getLocation().toFile(), false);
            command.setUsePreferenceTimeout("hg.timeout.log");
            command.addOptions("--debug", "--style", AbstractParseChangesetClient.getStyleFile(withFiles).getCanonicalPath());
            command.addOptions("--rev", nodeId);
            String result = command.executeToString();
            Map<IPath, SortedSet<ChangeSet>> revisions = HgLogClient.createMercurialRevisions(res, result, withFiles, ChangeSet.Direction.LOCAL, null, null, new IFilePatch[0]);
            SortedSet<ChangeSet> set = revisions.get(res.getLocation());
            if (set != null) {
                return set.first();
            }
            return null;
        }
        catch (IOException e) {
            throw new HgException(e.getLocalizedMessage(), e);
        }
    }
}

