/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import java.io.File;
import java.net.URI;

public class HgCloneClient {
    public static void clone(String parentDirectory, HgRepositoryLocation repo, boolean noUpdate, boolean pull, boolean uncompressed, boolean timeout, String rev, String cloneName) throws HgException {
        URI uri;
        HgCommand command = new HgCommand("clone", new File(parentDirectory), false);
        if (noUpdate) {
            command.addOptions("--noupdate");
        }
        if (pull) {
            command.addOptions("--pull");
        }
        if (uncompressed) {
            command.addOptions("--uncompressed");
        }
        if (rev != null && rev.length() > 0) {
            command.addOptions("--rev", rev);
        }
        if ((uri = repo.getUri()) != null) {
            command.addOptions(uri.toASCIIString());
        } else {
            command.addOptions(repo.getLocation());
        }
        if (cloneName != null) {
            command.addOptions(cloneName);
        }
        if (timeout) {
            command.setUsePreferenceTimeout("hg.timeout.clone");
            command.executeToBytes();
        } else {
            command.executeToBytes(Integer.MAX_VALUE);
        }
    }
}

