/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.Branch;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class HgBranchClient
extends AbstractClient {
    private static final Pattern GET_BRANCHES_PATTERN = Pattern.compile("^(.+[^ ]) +([0-9]+):([a-f0-9]+)( +(.+))?$");

    public static Branch[] getBranches(IProject project) throws HgException {
        HgCommand command = new HgCommand("branches", (IContainer)project, false);
        command.addOptions("-v");
        String[] lines = command.executeToString().split("\n");
        int length = lines.length;
        Branch[] branches = new Branch[length];
        int i = 0;
        while (i < length) {
            Branch branch;
            Matcher m = GET_BRANCHES_PATTERN.matcher(lines[i]);
            if (!m.matches()) {
                throw new HgException("Parse exception: '" + lines[i] + "'");
            }
            branches[i] = branch = new Branch(m.group(1), Integer.parseInt(m.group(2)), m.group(3), m.group(5) == null || !m.group(5).equals("(inactive)"));
            ++i;
        }
        return branches;
    }

    public static String addBranch(IResource resource, String name, String user, boolean force) throws HgException {
        HgCommand command = new HgCommand("branch", HgBranchClient.getWorkingDirectory(resource), false);
        if (force) {
            command.addOptions("-f");
        }
        command.addOptions(name);
        return command.executeToString();
    }

    public static String getActiveBranch(File workingDir) throws HgException {
        HgCommand command = new HgCommand("branch", HgBranchClient.getWorkingDirectory(workingDir), false);
        return command.executeToString().replaceAll("\n", "");
    }
}

