/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.SafeWorkspaceJob;
import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.commands.HgClients;
import com.vectrace.MercurialEclipse.commands.IConsole;
import com.vectrace.MercurialEclipse.exception.HgCoreException;
import com.vectrace.MercurialEclipse.exception.HgException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractShellCommand
extends AbstractClient {
    public static final int DEFAULT_TIMEOUT = 360000;
    public static final int MAX_PARAMS = 120;
    protected String command;
    protected List<String> commands;
    protected boolean escapeFiles;
    protected List<String> options = new ArrayList<String>();
    protected File workingDir;
    protected final List<String> files = new ArrayList<String>();
    private String timeoutConstant;
    private InputStreamConsumer consumer;
    private Process process;
    private boolean showOnConsole = true;

    protected AbstractShellCommand() {
    }

    public AbstractShellCommand(List<String> commands, File workingDir, boolean escapeFiles) {
        this();
        this.escapeFiles = escapeFiles;
        this.workingDir = workingDir;
        this.commands = commands;
    }

    public void addOptions(String ... optionsToAdd) {
        String[] stringArray = optionsToAdd;
        int n = optionsToAdd.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            this.options.add(option);
            ++n2;
        }
    }

    public byte[] executeToBytes() throws HgException {
        int timeout = 360000;
        if (this.timeoutConstant != null) {
            timeout = HgClients.getTimeOut(this.timeoutConstant);
        }
        return this.executeToBytes(timeout);
    }

    public byte[] executeToBytes(int timeout) throws HgException {
        return this.executeToBytes(timeout, true);
    }

    public byte[] executeToBytes(int timeout, boolean expectPositiveReturnValue) throws HgException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (this.executeToStream(bos, timeout, expectPositiveReturnValue)) {
            return bos.toByteArray();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public boolean executeToStream(OutputStream output, int timeout, boolean expectPositiveReturnValue) throws HgException {
        try {
            cmd = this.getCommands();
            cmdString = cmd.toString().replace(",", "").substring(1);
            commandInvoked = this.workingDir == null ? cmdString.substring(0, cmdString.length() - 1) : this.workingDir + File.separator + cmdString.substring(0, cmdString.length() - 1);
            charset = null;
            if (this.workingDir != null) {
                try {
                    hgRoot = HgClients.getHgRoot(this.workingDir);
                    charset = hgRoot.getEncoding();
                    cmd.add(2, "--config");
                    cmd.add(3, "ui.fallbackencoding=" + hgRoot.getFallbackencoding().name());
                }
                catch (HgCoreException v0) {}
            }
            builder = new ProcessBuilder(cmd);
            env = builder.environment();
            env.put("LANG", "en");
            env.put("LANGUAGE", "en");
            if (charset != null) {
                env.put("HGENCODING", charset.name());
            }
            builder.redirectErrorStream(true);
            if (this.workingDir != null) {
                builder.directory(this.workingDir);
            }
            this.process = builder.start();
            this.consumer = new InputStreamConsumer(commandInvoked, this.process.getInputStream(), output);
            this.consumer.start();
            this.logConsoleCommandInvoked(commandInvoked);
            this.consumer.join(timeout);
            msg = AbstractShellCommand.getMessage(output);
            if (this.consumer.isAlive()) ** GOTO lbl44
            exitCode = this.process.waitFor();
            if (exitCode == 0 || !expectPositiveReturnValue) {
                if (this.isDebugExecutionTime() || this.isDebugMode()) {
                    this.logConsoleCompleted(msg, exitCode, null);
                }
                return true;
            }
            try {
                hgex = new HgException(exitCode, AbstractShellCommand.getMessage(output));
                this.logConsoleCompleted(msg, exitCode, hgex);
                throw hgex;
lbl44:
                // 1 sources

                hgEx = new HgException("Process timeout");
                this.logConsoleError(msg, hgEx);
                throw hgEx;
            }
            catch (IOException e) {
                throw new HgException(e.getMessage(), e);
            }
            catch (InterruptedException e) {
                throw new HgException(e.getMessage(), e);
            }
        }
        finally {
            if (this.process != null) {
                this.process.destroy();
            }
        }
    }

    protected void logConsoleCommandInvoked(final String commandInvoked) {
        if (this.showOnConsole) {
            new SafeWorkspaceJob("Writing to console"){

                public IStatus runSafe(IProgressMonitor monitor) {
                    AbstractShellCommand.this.getConsole().commandInvoked(commandInvoked);
                    monitor.done();
                    return super.runSafe(monitor);
                }
            }.schedule();
        }
    }

    protected void logConsoleMessage(final String msg, final Throwable t) {
        if (this.showOnConsole) {
            new SafeWorkspaceJob("Writing to console"){

                public IStatus runSafe(IProgressMonitor monitor) {
                    AbstractShellCommand.this.getConsole().printMessage(msg, t);
                    monitor.done();
                    return super.runSafe(monitor);
                }
            }.schedule();
        }
    }

    protected void logConsoleError(final String msg, final HgException hgEx) {
        if (this.showOnConsole) {
            new SafeWorkspaceJob("Writing to console..."){

                public IStatus runSafe(IProgressMonitor monitor) {
                    if (msg != null) {
                        AbstractShellCommand.this.getConsole().printError(msg, (Throwable)((Object)hgEx));
                    } else {
                        AbstractShellCommand.this.getConsole().printError(hgEx.getMessage(), (Throwable)((Object)hgEx));
                    }
                    monitor.done();
                    return super.runSafe(monitor);
                }
            }.schedule();
        }
    }

    private void logConsoleCompleted(final String msg, final int exitCode, final HgException hgex) {
        if (this.showOnConsole) {
            new SafeWorkspaceJob("Writing to console..."){

                public IStatus runSafe(IProgressMonitor monitor) {
                    AbstractShellCommand.this.getConsole().commandCompleted(exitCode, msg, (Throwable)((Object)hgex));
                    monitor.done();
                    return super.runSafe(monitor);
                }
            }.schedule();
        }
    }

    private static String getMessage(OutputStream output) {
        String msg = null;
        if (output instanceof FileOutputStream) {
            return null;
        }
        if (output instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream baos = (ByteArrayOutputStream)output;
            try {
                msg = baos.toString("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                MercurialEclipsePlugin.logError(e);
                msg = baos.toString();
            }
        }
        return msg;
    }

    private boolean isDebugMode() {
        return Boolean.valueOf(HgClients.getPreference("hg.console.debug", "false"));
    }

    private boolean isDebugExecutionTime() {
        return Boolean.valueOf(HgClients.getPreference("hg.console.debug.time", "false"));
    }

    public String executeToString() throws HgException {
        byte[] bytes = this.executeToBytes();
        if (bytes != null && bytes.length > 0) {
            try {
                return new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new HgException(e.getLocalizedMessage(), e);
            }
        }
        return "";
    }

    public boolean executeToFile(File file, int timeout, boolean expectPositiveReturnValue) throws HgException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file, false);
            boolean bl = this.executeToStream(fos, timeout, expectPositiveReturnValue);
            return bl;
        }
        catch (FileNotFoundException e) {
            throw new HgException(e.getMessage(), e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    throw new HgException(e.getMessage(), e);
                }
            }
        }
    }

    protected List<String> getCommands() {
        if (this.commands != null) {
            return this.commands;
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getExecutable());
        result.add(this.command);
        result.addAll(this.options);
        if (this.escapeFiles && !this.files.isEmpty()) {
            result.add("--");
        }
        result.addAll(this.files);
        return result;
    }

    protected abstract String getExecutable();

    public void addFiles(String ... myFiles) {
        String[] stringArray = myFiles;
        int n = myFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            this.files.add(file);
            ++n2;
        }
    }

    public void addFiles(Collection<String> myFiles) {
        this.files.addAll(myFiles);
    }

    public void addFiles(IResource ... resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            this.files.add(resource.getLocation().toOSString());
            ++n2;
        }
    }

    public void addFiles(List<? extends IResource> resources) {
        for (IResource iResource : resources) {
            this.files.add(iResource.getLocation().toOSString());
        }
    }

    public void setUsePreferenceTimeout(String cloneTimeout) {
        this.timeoutConstant = cloneTimeout;
    }

    public void terminate() {
        if (this.consumer != null) {
            this.consumer.interrupt();
        }
        this.process.destroy();
    }

    private IConsole getConsole() {
        return HgClients.getConsole();
    }

    public void setShowOnConsole(boolean b) {
        this.showOnConsole = b;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append(" [");
        if (this.command != null) {
            builder.append("command=");
            builder.append(this.command);
            builder.append(", ");
        }
        if (this.commands != null) {
            builder.append("commands=");
            builder.append(this.commands);
            builder.append(", ");
        }
        if (this.options != null) {
            builder.append("options=");
            builder.append(this.options);
            builder.append(", ");
        }
        if (this.workingDir != null) {
            builder.append("workingDir=");
            builder.append(this.workingDir);
            builder.append(", ");
        }
        if (this.files != null) {
            builder.append("files=");
            builder.append(this.files);
            builder.append(", ");
        }
        builder.append("escapeFiles=");
        builder.append(this.escapeFiles);
        builder.append(", ");
        if (this.consumer != null) {
            builder.append("consumer=");
            builder.append(this.consumer);
            builder.append(", ");
        }
        if (this.process != null) {
            builder.append("process=");
            builder.append(this.process);
            builder.append(", ");
        }
        builder.append("showOnConsole=");
        builder.append(this.showOnConsole);
        builder.append(", ");
        if (this.timeoutConstant != null) {
            builder.append("timeoutConstant=");
            builder.append(this.timeoutConstant);
        }
        builder.append("]");
        return builder.toString();
    }

    private static class InputStreamConsumer
    extends Thread {
        private final InputStream stream;
        private final OutputStream output;

        public InputStreamConsumer(String name, InputStream stream, OutputStream output) {
            super(name);
            this.output = output;
            this.stream = new BufferedInputStream(stream);
        }

        public void run() {
            try {
                try {
                    int length;
                    byte[] buffer = new byte[8192];
                    while ((length = this.stream.read(buffer)) != -1) {
                        this.output.write(buffer, 0, length);
                    }
                }
                catch (IOException e) {
                    if (!InputStreamConsumer.interrupted()) {
                        HgClients.logError(e);
                    }
                    try {
                        this.stream.close();
                    }
                    catch (IOException e2) {
                        HgClients.logError(e2);
                    }
                    try {
                        this.output.close();
                    }
                    catch (IOException e3) {
                        HgClients.logError(e3);
                    }
                }
            }
            finally {
                try {
                    this.stream.close();
                }
                catch (IOException e) {
                    HgClients.logError(e);
                }
                try {
                    this.output.close();
                }
                catch (IOException e) {
                    HgClients.logError(e);
                }
            }
        }
    }
}

