/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.annotations;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.HgFile;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.quickdiff.IQuickDiffReferenceProvider;

public class HgPristineCopyQuickDiffProvider
implements IQuickDiffReferenceProvider {
    public static final String HG_REFERENCE_PROVIDER = "com.vectrace.MercurialEclipse.annotatations.HgReferenceProvider";
    private ITextEditor editor = null;
    private IDocument referenceDocument = null;
    private boolean isReferenceInitialized = false;
    private IDocumentProvider documentProvider = null;
    private String id;
    private Job fUpdateJob;
    private IElementStateListener documentListener = new IElementStateListener(){

        public void elementDirtyStateChanged(Object element, boolean isDirty) {
        }

        public void elementContentAboutToBeReplaced(Object element) {
        }

        public void elementContentReplaced(Object element) {
            if (HgPristineCopyQuickDiffProvider.this.editor != null && HgPristineCopyQuickDiffProvider.this.editor.getEditorInput() == element) {
                HgPristineCopyQuickDiffProvider.this.fetchContentsInJob();
            }
        }

        public void elementDeleted(Object element) {
        }

        public void elementMoved(Object originalElement, Object movedElement) {
        }
    };

    public IDocument getReference(IProgressMonitor monitor) throws CoreException {
        if (!this.isReferenceInitialized) {
            return null;
        }
        if (this.referenceDocument == null) {
            this.readDocument(monitor);
        }
        return this.referenceDocument;
    }

    public void setActiveEditor(ITextEditor targetEditor) {
        if (!(targetEditor.getEditorInput() instanceof IFileEditorInput)) {
            return;
        }
        this.editor = targetEditor;
        this.documentProvider = this.editor.getDocumentProvider();
        if (this.documentProvider != null) {
            this.documentProvider.addElementStateListener(this.documentListener);
        }
        this.isReferenceInitialized = true;
    }

    public boolean isEnabled() {
        if (!this.isReferenceInitialized) {
            return false;
        }
        return this.getManagedHgFile() != null;
    }

    public void dispose() {
        this.isReferenceInitialized = false;
        if (this.fUpdateJob != null && this.fUpdateJob.getState() != 0) {
            this.fUpdateJob.cancel();
        }
        if (this.documentProvider != null) {
            this.documentProvider.removeElementStateListener(this.documentListener);
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    private boolean computeChange(IProgressMonitor monitor) throws TeamException {
        boolean needToUpdateReferenceDocument = false;
        if (this.isReferenceInitialized) {
            needToUpdateReferenceDocument = this.getFileFromEditor().isSynchronized(1);
        }
        return needToUpdateReferenceDocument;
    }

    private void readDocument(IProgressMonitor monitor) throws CoreException {
        if (!this.isReferenceInitialized) {
            return;
        }
        if (this.referenceDocument == null) {
            this.referenceDocument = new Document();
        }
        if (this.computeChange(monitor)) {
            IFile remoteFile = this.getFileFromEditor();
            if (remoteFile != null && this.documentProvider instanceof IStorageDocumentProvider) {
                IStorageDocumentProvider provider = (IStorageDocumentProvider)this.documentProvider;
                String encoding = provider.getEncoding((Object)this.editor.getEditorInput());
                if (encoding == null) {
                    encoding = provider.getDefaultEncoding();
                }
                if (monitor.isCanceled()) {
                    return;
                }
                InputStream stream = remoteFile.getContents();
                if (stream == null || monitor.isCanceled() || !this.isReferenceInitialized) {
                    return;
                }
                HgPristineCopyQuickDiffProvider.setDocumentContent(this.referenceDocument, stream, encoding);
            } else {
                if (monitor.isCanceled()) {
                    return;
                }
                this.referenceDocument.set("");
            }
        }
    }

    private static void setDocumentContent(IDocument document, InputStream contentStream, String encoding) throws CoreException {
        Reader in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader(contentStream, encoding), 15360);
                CharArrayWriter caw = new CharArrayWriter(15360);
                char[] readBuffer = new char[2048];
                int n = in.read(readBuffer);
                while (n > 0) {
                    caw.write(readBuffer, 0, n);
                    n = in.read(readBuffer);
                }
                document.set(caw.toString());
            }
            catch (IOException x) {
                throw new HgException("RemoteRevisionQuickDiffProvider.readingFile", x);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException x) {
                    throw new HgException("RemoteRevisionQuickDiffProvider.closingFile", x);
                }
            }
        }
    }

    private HgFile getManagedHgFile() {
        IFile file;
        if (this.editor != null && (file = this.getFileFromEditor()) != null && MercurialUtilities.hgIsTeamProviderFor((IResource)file, false)) {
            try {
                HgFile hgFile = new HgFile(file.getLocation().toFile());
                if (hgFile.exists()) {
                    return hgFile;
                }
            }
            catch (IOException e) {
                MercurialEclipsePlugin.logError(e);
            }
            catch (CoreException e) {
                MercurialEclipsePlugin.logError(e);
            }
            return null;
        }
        return null;
    }

    private IFile getFileFromEditor() {
        IEditorInput input;
        if (this.editor != null && (input = this.editor.getEditorInput()) instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return null;
    }

    private void fetchContentsInJob() {
        if (!this.isReferenceInitialized) {
            return;
        }
        if (this.fUpdateJob != null && this.fUpdateJob.getState() != 0) {
            this.fUpdateJob.cancel();
        }
        this.fUpdateJob = new Job("RemoteRevisionQuickDiffProvider.fetchingFile"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    HgPristineCopyQuickDiffProvider.this.readDocument(monitor);
                }
                catch (CoreException coreException) {}
                return Status.OK_STATUS;
            }
        };
        this.fUpdateJob.schedule();
    }
}

