/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.flatfiles.wizard;

import com.quantum.model.Bookmark;
import com.quantum.model.Column;
import com.quantum.model.DatabaseObject;
import com.quantum.model.Entity;
import com.quantum.model.ForeignKey;
import com.quantum.model.Schema;
import com.quantum.util.connection.NotConnectedException;
import com.quantum.util.sql.TypesHelper;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;

public class TorqueConverter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public void convert(Writer writer, Bookmark bookmark, Schema schema, String databaseName, String defaultIdMethod) throws IOException, NotConnectedException, SQLException {
        DatabaseObject[] tables = bookmark.getObjectsForSchema(schema, "TABLE");
        writer.write("<?xml version=\"1.0\" ?>");
        writer.write(LINE_SEPARATOR);
        writer.write("<!DOCTYPE database SYSTEM ");
        writer.write("\"http://db.apache.org/torque/dtd/database_3_1.dtd\">");
        writer.write(LINE_SEPARATOR);
        writer.write("<database name=\"");
        writer.write(databaseName);
        writer.write("\" defaultIdMethod=\"");
        writer.write(defaultIdMethod);
        writer.write("\">");
        int i = 0;
        int length = tables == null ? 0 : tables.length;
        while (i < length) {
            if ("TABLE".equals(tables[i].getType())) {
                this.convert(writer, (Entity)tables[i]);
            }
            ++i;
        }
        writer.write(LINE_SEPARATOR);
        writer.write("</database>");
    }

    private void convert(Writer writer, Entity entity) throws IOException, NotConnectedException, SQLException {
        writer.write(LINE_SEPARATOR);
        writer.write("\t<table name=\"");
        writer.write(entity.getName());
        writer.write("\" >");
        Column[] columns = entity.getColumns();
        int i = 0;
        int length = columns == null ? 0 : columns.length;
        while (i < length) {
            this.convert(writer, columns[i]);
            ++i;
        }
        ForeignKey[] foreignKeys = entity.getImportedKeys();
        int i2 = 0;
        int length2 = foreignKeys == null ? 0 : foreignKeys.length;
        while (i2 < length2) {
            this.convert(writer, foreignKeys[i2]);
            ++i2;
        }
        writer.write(LINE_SEPARATOR);
        writer.write("\t</table>");
    }

    public void convert(Writer writer, ForeignKey foreignKey) throws IOException, NotConnectedException, SQLException {
        writer.write(LINE_SEPARATOR);
        writer.write("\t\t<foreign-key foreignTable=\"");
        writer.write(foreignKey.getLocalEntityName());
        writer.write("\">");
        int i = 0;
        int length = foreignKey.getNumberOfColumns();
        while (i < length) {
            writer.write(LINE_SEPARATOR);
            writer.write("\t\t\t<reference local=\"");
            writer.write(foreignKey.getForeignColumnName(i));
            writer.write("\" foreign=\"");
            writer.write(foreignKey.getLocalColumnName(i));
            writer.write("\" />");
            ++i;
        }
        writer.write(LINE_SEPARATOR);
        writer.write("\t\t</foreign-key>");
    }

    public void convert(Writer writer, Column column) throws IOException, NotConnectedException, SQLException {
        writer.write(LINE_SEPARATOR);
        writer.write("\t\t<column name=\"");
        writer.write(column.getName());
        if (column.isPrimaryKey()) {
            writer.write("\" primaryKey=\"true");
        }
        writer.write("\" required=\"");
        writer.write(column.isNullable() ? "false" : "true");
        writer.write("\" type=\"");
        writer.write(this.getTypeString(column.getType()));
        if (this.hasSize(column.getType())) {
            writer.write("\" size=\"");
            writer.write(this.getSizeString(column));
        }
        writer.write("\" />");
    }

    private String getSizeString(Column column) {
        if (this.hasSize(column.getType())) {
            return column.getSize() + (column.getNumberOfFractionalDigits() != 0 ? "," + column.getNumberOfFractionalDigits() : "");
        }
        return "";
    }

    private boolean hasSize(int type) {
        switch (type) {
            case -1: 
            case 1: 
            case 3: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private String getTypeString(int type) {
        String typeAsString = TypesHelper.getTypeName((int)type);
        return typeAsString == null ? TypesHelper.getTypeName((int)4) : typeAsString;
    }
}

