/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.flatfiles.wizard;

import com.quantum.QuantumPlugin;
import com.quantum.flatfiles.MessageUtil;
import com.quantum.flatfiles.QuantumFlatFilesPlugin;
import com.quantum.flatfiles.converter.ConverterFactory;
import com.quantum.sql.SQLResultSetResults;
import com.quantum.sql.Scrollable;
import com.quantum.view.widget.ComboViewer;
import com.quantum.wizards.PropertyChangeWizardPage;
import java.io.File;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class ExportResultSetDataWizardPage
extends PropertyChangeWizardPage {
    private final SQLResultSetResults results;
    private Text fileName;
    private Button overwrite;
    private String exportType = "excel";
    static /* synthetic */ Class class$0;

    protected ExportResultSetDataWizardPage(String pageName, SQLResultSetResults results) {
        super(pageName);
        this.setTitle(MessageUtil.getString(((Object)((Object)this)).getClass(), "title"));
        this.setDescription(MessageUtil.getString(((Object)((Object)this)).getClass(), "description"));
        this.results = results;
    }

    public void createControl(Composite parent) {
        this.setPageComplete(false);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.createRowsPart(composite);
        Label label = new Label(composite, 0);
        label.setText(MessageUtil.getString(((Object)((Object)this)).getClass(), "fileName"));
        this.fileName = new Text(composite, 2052);
        this.fileName.setLayoutData((Object)new GridData(768));
        Button browse = new Button(composite, 8);
        browse.setText(MessageUtil.getString(((Object)((Object)this)).getClass(), "browse"));
        browse.setLayoutData((Object)new GridData(256));
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(ExportResultSetDataWizardPage.this.getShell(), 8192);
                String filename = dialog.open();
                if (filename != null) {
                    ExportResultSetDataWizardPage.this.fileName.setText(filename);
                    ExportResultSetDataWizardPage.this.validate(filename);
                }
            }
        });
        this.fileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ExportResultSetDataWizardPage.this.validate(((Text)event.getSource()).getText());
            }
        });
        label = new Label(composite, 0);
        label.setText(MessageUtil.getString(((Object)((Object)this)).getClass(), "exportFormat"));
        ComboViewer viewer = new ComboViewer(composite);
        viewer.getControl().setLayoutData((Object)new GridData(768));
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof String[]) {
                    return (String[])inputElement;
                }
                return null;
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String string;
                if (element == null) {
                    string = "";
                } else {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.quantum.flatfiles.converter.ConverterFactory");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    string = MessageUtil.getString(clazz, (String)element);
                }
                return string;
            }
        });
        viewer.setInput((Object)ConverterFactory.getConverterTypes());
        viewer.setSelection((ISelection)new StructuredSelection((Object)"excel"));
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ExportResultSetDataWizardPage.this.setExportType(selection.isEmpty() ? null : (String)selection.getFirstElement());
            }
        });
        Label filler = new Label(composite, 0);
        filler.setText("");
        filler.setLayoutData((Object)new GridData(32));
        IPreferenceStore store = QuantumPlugin.getDefault().getPreferenceStore();
        boolean confirmOverwrite = store.getBoolean("com.quantum.export.confirmOverwrite");
        this.overwrite = new Button(composite, 32);
        this.overwrite.setSelection(confirmOverwrite);
        this.overwrite.setText(MessageUtil.getString(((Object)((Object)this)).getClass(), "overwrite"));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.overwrite.setLayoutData((Object)gridData);
        this.setControl((Control)composite);
    }

    protected void setExportType(String exportType) {
        this.exportType = exportType;
        IPreferenceStore store = QuantumFlatFilesPlugin.getDefault().getPreferenceStore();
        String defaultCSVFileName = String.valueOf(store.getString("com.quantum.flatfiles.CSV.defaultPath")) + store.getString("com.quantum.flatfiles.CSV.defaultFileName");
        if (exportType.equals("csv")) {
            if (this.fileName.getText().equals("")) {
                this.fileName.setText(defaultCSVFileName);
            }
        } else if (this.fileName.getText().equals(defaultCSVFileName)) {
            this.fileName.setText("");
        }
    }

    private void validate(String fileName) {
        File file = new File(fileName);
        if (file.exists() && file.isFile()) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else if (!file.exists() && !fileName.endsWith(File.separator)) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(MessageUtil.getString(((Object)((Object)this)).getClass(), "invalidFileName"));
            this.setPageComplete(false);
        }
    }

    private void createRowsPart(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(MessageUtil.getString(((Object)((Object)this)).getClass(), "rows"));
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)data);
        Button allRowsButton = new Button((Composite)group, 16);
        allRowsButton.setText(MessageUtil.getString(((Object)((Object)this)).getClass(), "allRows"));
        Button currentRowsButton = new Button((Composite)group, 16);
        if (this.results instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)this.results;
            currentRowsButton.setText(MessageUtil.getString(((Object)((Object)this)).getClass(), "currentRowsWithRange", new Object[]{new Integer(scrollable.getStart()), new Integer(scrollable.getEnd())}));
            if (scrollable.hasNextPage() || scrollable.hasPreviousPage()) {
                currentRowsButton.setSelection(true);
            } else {
                currentRowsButton.setEnabled(false);
            }
        } else {
            currentRowsButton.setText(MessageUtil.getString(((Object)((Object)this)).getClass(), "currentRows"));
            currentRowsButton.setEnabled(false);
        }
    }

    public String getFileName() {
        return this.fileName == null ? null : this.fileName.getText();
    }

    public boolean overwriteFile() {
        return this.overwrite == null ? false : this.overwrite.getSelection();
    }

    public String getExportType() {
        return this.exportType;
    }
}

