/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.flatfiles.wizard;

import com.quantum.flatfiles.MessageUtil;
import com.quantum.flatfiles.wizard.InputStreamProvider;
import com.quantum.view.widget.ErrorMessageDisplayer;
import com.quantum.view.widget.FileSelectionWidget;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class ExportDDLWizardFileSelectionPage
extends WizardNewFileCreationPage
implements ErrorMessageDisplayer,
PropertyChangeListener {
    private Tree resourceTree;
    private Text resourceName;
    private Text workspaceFileName;
    private final InputStreamProvider inputStreamProvider;
    private FileSelectionWidget fileSelection;
    private boolean saveInFileSystem = true;

    public ExportDDLWizardFileSelectionPage(String pageName, InputStreamProvider inputStreamProvider) {
        super(pageName, (IStructuredSelection)new StructuredSelection());
        this.inputStreamProvider = inputStreamProvider;
        this.setFileName("create.sql");
        this.setTitle(MessageUtil.getString(this.getClass(), "title"));
        this.setDescription(MessageUtil.getString(this.getClass(), "description"));
    }

    public void createControl(Composite parent) {
        Composite topLevel1 = new Composite(parent, 0);
        topLevel1.setLayout((Layout)new GridLayout(2, false));
        topLevel1.setLayoutData((Object)new GridData(272));
        Button fileSystemRadioButton = new Button(topLevel1, 16);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        fileSystemRadioButton.setLayoutData((Object)gridData);
        fileSystemRadioButton.setText(MessageUtil.getString(this.getClass(), "saveInFileSystem"));
        fileSystemRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.getSource();
                ExportDDLWizardFileSelectionPage.this.changeOptions(button.getSelection());
            }
        });
        Label label = new Label(topLevel1, 0);
        label.setText("");
        this.fileSelection = new FileSelectionWidget(topLevel1, 0, (ErrorMessageDisplayer)this);
        Button workspaceRadioButton = new Button(topLevel1, 16);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        workspaceRadioButton.setLayoutData((Object)gridData);
        workspaceRadioButton.setText(MessageUtil.getString(this.getClass(), "saveInWorkspace"));
        workspaceRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.getSource();
                ExportDDLWizardFileSelectionPage.this.changeOptions(!button.getSelection());
            }
        });
        label = new Label(topLevel1, 0);
        label.setText("");
        Composite composite = new Composite(topLevel1, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        super.createControl(composite);
        Composite control = (Composite)this.getControl();
        this.findParts(control);
        this.setControl((Control)topLevel1);
        fileSystemRadioButton.setSelection(true);
        this.changeOptions(true);
        this.fileSelection.addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void findParts(Composite composite) {
        Control[] controls = composite.getChildren();
        int i = 0;
        int length = controls == null ? 0 : controls.length;
        while (i < length) {
            if (controls[i] instanceof Tree) {
                this.resourceTree = (Tree)controls[i];
            } else if (controls[i] instanceof Composite) {
                this.findParts((Composite)controls[i]);
            } else if (controls[i] instanceof Text && this.resourceName != null) {
                this.workspaceFileName = (Text)controls[i];
            } else if (controls[i] instanceof Text && this.resourceName == null) {
                this.resourceName = (Text)controls[i];
            } else if (controls[i] instanceof Button) {
                Button button = (Button)controls[i];
                button.setVisible(false);
                button.setEnabled(false);
            }
            ++i;
        }
    }

    private void changeOptions(boolean fileSystem) {
        if (this.resourceName != null) {
            this.resourceName.setEnabled(!fileSystem);
        }
        if (this.resourceTree != null) {
            this.resourceTree.setEnabled(!fileSystem);
        }
        if (this.workspaceFileName != null) {
            this.workspaceFileName.setEnabled(!fileSystem);
        }
        this.fileSelection.setEnabled(fileSystem);
        if (fileSystem) {
            this.setPageComplete(this.fileSelection.getFile() != null);
        } else {
            this.setPageComplete(super.validatePage());
        }
        this.saveInFileSystem = fileSystem;
    }

    public void dispose() {
        super.dispose();
        this.fileSelection.removePropertyChangeListener((PropertyChangeListener)this);
    }

    protected InputStream getInitialContents() {
        return this.inputStreamProvider.getInputStream();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("file".equals(event.getPropertyName())) {
            this.setPageComplete(event.getNewValue() != null);
        }
    }

    public Object createOutputFile() {
        if (this.saveInFileSystem) {
            return this.fileSelection.createFile(this.getInitialContents());
        }
        return this.createNewFile();
    }
}

