/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.flatfiles.converter;

import com.quantum.csv.wizard.ConverterCSV;
import com.quantum.flatfiles.QuantumFlatFilesPlugin;
import com.quantum.flatfiles.converter.Converter;
import com.quantum.sql.SQLResultSetResults;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import org.eclipse.jface.preference.IPreferenceStore;

public class ResultSetToCSVConverter
implements Converter {
    private IPreferenceStore store = QuantumFlatFilesPlugin.getDefault().getPreferenceStore();
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public void convert(String fileName, SQLResultSetResults results) throws IOException {
        File outputFile = new File(fileName);
        FileWriter writer = new FileWriter(outputFile);
        String defaultColumnSeparator = this.store.getString("com.quantum.flatfiles.CSV.columnSeparator");
        if (defaultColumnSeparator == "") {
            defaultColumnSeparator = ",";
        }
        defaultColumnSeparator = defaultColumnSeparator.substring(0, 1);
        String[] columns = results.getColumnNames();
        if (this.store.getBoolean("com.quantum.flatfiles.CSV.writeHeaders")) {
            writer.write(ConverterCSV.filter(columns, defaultColumnSeparator.charAt(0)));
            writer.write(LINE_SEPARATOR);
        }
        Iterator i = results.getRowIterator();
        while (i.hasNext()) {
            SQLResultSetResults.Row row = (SQLResultSetResults.Row)i.next();
            writer.write(ConverterCSV.filter(row.getAsStringArray(), defaultColumnSeparator.charAt(0)));
            writer.write(LINE_SEPARATOR);
            writer.flush();
        }
        writer.close();
    }

    public String getFileExtension() {
        return ".csv";
    }
}

