/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.flatfiles.converter;

import com.quantum.flatfiles.converter.Converter;
import com.quantum.flatfiles.converter.ResultSetToCSVConverter;
import com.quantum.flatfiles.converter.ResultSetToFilteredConverter;
import com.quantum.flatfiles.converter.ResultSetToSpreadSheetConverter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ConverterFactory {
    public static final String EXCEL_SPREADSHEET = "excel";
    public static final String COMMA_SEPARATED_VALUES = "csv";
    public static final String CUSTOM_FILTERED_TEXT = "filtered";
    private static final Map converterMap;

    static {
        HashMap<String, Converter> map = new HashMap<String, Converter>();
        map.put(EXCEL_SPREADSHEET, new ResultSetToSpreadSheetConverter());
        map.put(COMMA_SEPARATED_VALUES, new ResultSetToCSVConverter());
        map.put(COMMA_SEPARATED_VALUES, new ResultSetToFilteredConverter());
        converterMap = Collections.unmodifiableMap(map);
    }

    public static String[] getConverterTypes() {
        Set set = converterMap.keySet();
        return set.toArray(new String[set.size()]);
    }

    public static Converter getConverter(String type) {
        return (Converter)converterMap.get(type);
    }
}

