/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.csv.wizard;

import com.quantum.ImageStore;
import com.quantum.QuantumPlugin;
import com.quantum.flatfiles.MessageUtil;
import com.quantum.flatfiles.QuantumFlatFilesPlugin;
import com.quantum.model.Entity;
import com.quantum.view.bookmark.BookmarkView;
import com.quantum.view.bookmark.EntityNode;
import com.quantum.view.widget.SimpleLabelProvider;
import java.io.File;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ExportCSVDetailsPage
extends WizardPage {
    private String fileName;
    private boolean writeHeaderRow = true;
    private TableViewer tableViewer;
    private ContentProviderImpl contentProvider;
    private Entity[] entities;
    private char columnSeparator = (char)44;
    private IPreferenceStore store = QuantumFlatFilesPlugin.getDefault().getPreferenceStore();
    static /* synthetic */ Class class$0;

    protected void refreshTable() {
    }

    public void dispose() {
        super.dispose();
    }

    protected ExportCSVDetailsPage(String pageName) {
        super(pageName);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.csv.wizard.ExportCSVDetailsPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setTitle(MessageUtil.getString(clazz, "title"));
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.quantum.csv.wizard.ExportCSVDetailsPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setDescription(MessageUtil.getString(clazz2, "description"));
    }

    public void createControl(Composite parent) {
        this.writeHeaderRow = this.store.getBoolean("com.quantum.flatfiles.CSV.writeHeaders");
        final Composite parentf = parent;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.csv.wizard.ExportCSVDetailsPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        label.setText(MessageUtil.getString(clazz, "selectedEntities"));
        label.setLayoutData((Object)new GridData(2));
        this.tableViewer = new TableViewer(composite);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new SimpleLabelProvider(ImageStore.getImage((String)"bigtable", (AbstractUIPlugin)QuantumPlugin.getDefault())));
        this.contentProvider = new ContentProviderImpl();
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.tableViewer.setInput((Object)BookmarkView.getInstance().getSelection());
        this.tableViewer.getControl().setLayoutData((Object)new GridData(1808));
        Object[] nodes = this.contentProvider.getElements(BookmarkView.getInstance().getSelection());
        this.entities = new Entity[nodes.length];
        int i = 0;
        while (i < nodes.length) {
            EntityNode entityNode;
            Object node = nodes[i];
            if (node instanceof EntityNode && ((entityNode = (EntityNode)node).isTable() || entityNode.isView())) {
                this.entities[i] = entityNode.getEntity();
            }
            ++i;
        }
        Group group = new Group(composite, 0);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.quantum.csv.wizard.ExportCSVDetailsPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        group.setText(MessageUtil.getString(clazz2, "options"));
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(4, 0, false, false));
        Button headerRow = new Button((Composite)group, 32);
        headerRow.setText(MessageUtil.getString(((Object)((Object)this)).getClass(), "headerRow"));
        headerRow.setSelection(this.writeHeaderRow);
        headerRow.setLayoutData((Object)new GridData(1, 0, false, false));
        headerRow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportCSVDetailsPage.this.writeHeaderRow = ((Button)event.getSource()).getSelection();
            }
        });
        Composite columnSeparatorGrid = new Composite((Composite)group, 0);
        columnSeparatorGrid.setLayout((Layout)new GridLayout(2, false));
        new Label(columnSeparatorGrid, 0).setText("Column separator:");
        Text columnSeparatorText = new Text(columnSeparatorGrid, 2048);
        String defaultColumnSeparator = this.store.getString("com.quantum.flatfiles.CSV.columnSeparator");
        if (defaultColumnSeparator == "") {
            defaultColumnSeparator = ",";
        }
        columnSeparatorText.setText(defaultColumnSeparator.substring(0, 1));
        columnSeparatorText.setTextLimit(1);
        columnSeparatorText.setLayoutData((Object)new GridData(768));
        columnSeparatorText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String columnSeparatorStr = ((Text)event.getSource()).getText();
                if (columnSeparatorStr.length() != 1) {
                    ((Text)event.getSource()).setBackground(parentf.getDisplay().getSystemColor(3));
                } else {
                    ((Text)event.getSource()).setBackground(parentf.getDisplay().getSystemColor(1));
                }
                if (columnSeparatorStr.length() > 0) {
                    ExportCSVDetailsPage.this.columnSeparator = columnSeparatorStr.charAt(0);
                } else {
                    ExportCSVDetailsPage.this.columnSeparator = ',';
                }
            }
        });
        Label blankArea = new Label(composite, 0);
        blankArea.setText("");
        this.createDestinationArea(composite);
        this.setControl((Control)composite);
        this.updateState();
    }

    private void createDestinationArea(Composite composite) {
        Composite fileArea = new Composite(composite, 0);
        fileArea.setLayout((Layout)new GridLayout(3, false));
        fileArea.setLayoutData((Object)new GridData(770));
        Label label = new Label(fileArea, 0);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.csv.wizard.ExportCSVDetailsPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        label.setText(MessageUtil.getString(clazz, "fileName"));
        final Text fileNameText = new Text(fileArea, 2048);
        String defaultFileName = String.valueOf(this.store.getString("com.quantum.flatfiles.CSV.defaultPath")) + this.store.getString("com.quantum.flatfiles.CSV.defaultFileName");
        fileNameText.setText(defaultFileName);
        if (defaultFileName != "") {
            this.setFileName(this.appendExtension(defaultFileName));
            this.updateState();
        }
        fileNameText.setLayoutData((Object)new GridData(768));
        fileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String filename = ((Text)event.getSource()).getText();
                ExportCSVDetailsPage.this.setFileName(ExportCSVDetailsPage.this.appendExtension(filename));
                ExportCSVDetailsPage.this.updateState();
            }
        });
        Button button = new Button(fileArea, 0);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.quantum.csv.wizard.ExportCSVDetailsPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        button.setText(MessageUtil.getString(clazz2, "browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(ExportCSVDetailsPage.this.getShell(), 8192);
                String extension = ExportCSVDetailsPage.this.entities.length > 1 ? "*.zip" : "*.csv";
                dialog.setFilterExtensions(new String[]{extension});
                String[] stringArray = new String[1];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.quantum.csv.wizard.ExportCSVDetailsPage");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                stringArray[0] = MessageUtil.getString(clazz, ExportCSVDetailsPage.this.entities.length > 1 ? "zipFiles" : "csvFiles");
                dialog.setFilterNames(stringArray);
                String filename = dialog.open();
                if (filename != null) {
                    fileNameText.setText(filename);
                    ExportCSVDetailsPage.this.setFileName(filename);
                    ExportCSVDetailsPage.this.updateState();
                }
            }
        });
    }

    protected String appendExtension(String filename) {
        String extension = this.entities.length > 1 ? ".zip" : ".csv";
        filename = filename != "" && filename.indexOf(46) < 0 ? String.valueOf(filename) + extension : filename;
        return filename;
    }

    protected void updateState() {
        boolean pageComplete = this.entities != null && this.entities.length > 0;
        this.setPageComplete(pageComplete &= this.fileName != null && this.fileName != "" && !new File(this.fileName).isDirectory());
    }

    public String getFileName() {
        return this.fileName;
    }

    protected void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Entity[] getEntities() {
        return this.entities;
    }

    public void setEntities(Entity[] entities) {
        this.entities = entities;
    }

    public boolean isWriteHeaderRow() {
        return this.writeHeaderRow;
    }

    public void setWriteHeaderRow(boolean writeHeaderRow) {
        this.writeHeaderRow = writeHeaderRow;
    }

    public char getColumnSeparator() {
        return this.columnSeparator;
    }

    public class ContentProviderImpl
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof StructuredSelection) {
                Object[] entities = ((StructuredSelection)inputElement).toArray();
                return entities;
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

