/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.csv.wizard;

import com.quantum.csv.wizard.CSVParser;
import com.quantum.model.Entity;
import com.quantum.sql.SQLVirtualResultSet;
import com.quantum.util.StringMatrix;
import com.quantum.util.connection.NotConnectedException;
import com.quantum.util.sql.SQLInstructionBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import java.util.zip.ZipOutputStream;

public class ConverterCSV {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private long numGoodInserts;
    private long numBadInserts;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void convert(Writer writer, Entity entity, boolean headerRow, char columnSeparator) throws IOException, NotConnectedException, SQLException {
        SQLVirtualResultSet rs = new SQLVirtualResultSet(entity, 1003, 1007);
        if (headerRow) {
            writer.write(ConverterCSV.filter(rs.getColumnNames(), columnSeparator));
            writer.write(LINE_SEPARATOR);
        }
        try {
            while (rs.next()) {
                writer.write(ConverterCSV.filter(rs.getRowAsStringArray(), columnSeparator));
                writer.write(LINE_SEPARATOR);
                writer.flush();
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            rs.close();
            throw throwable;
        }
        rs.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void convert(ZipOutputStream zipOS, Entity entity, boolean headerRow, char columnSeparator) throws IOException, NotConnectedException, SQLException {
        SQLVirtualResultSet rs = new SQLVirtualResultSet(entity, 1003, 1007);
        if (headerRow) {
            zipOS.write(ConverterCSV.filter(rs.getColumnNames(), columnSeparator).getBytes());
            zipOS.write(LINE_SEPARATOR.getBytes());
        }
        try {
            while (rs.next()) {
                zipOS.write(ConverterCSV.filter(rs.getRowAsStringArray(), columnSeparator).getBytes());
                zipOS.write(LINE_SEPARATOR.getBytes());
                zipOS.flush();
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            rs.close();
            throw throwable;
        }
        rs.close();
    }

    public static String filter(String[] columnValues, char columnSeparator) {
        String result = "";
        int i = 0;
        while (i < columnValues.length) {
            if (i > 0) {
                result = String.valueOf(result) + columnSeparator;
            }
            result = String.valueOf(result) + ConverterCSV.filter(columnValues[i], columnSeparator);
            ++i;
        }
        return result;
    }

    private static String filter(String string, char columnSeparator) {
        if (string == null) {
            return "";
        }
        if (ConverterCSV.isClean(string, columnSeparator) && string.length() > 0) {
            return string;
        }
        return ConverterCSV.quote(string);
    }

    private static String quote(String s) {
        if (s == null) {
            return "";
        }
        return "\"" + s.replaceAll("\"", "\"\"") + "\"";
    }

    private static boolean isClean(String s, char columnSeparator) {
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == columnSeparator || c == '\"' || i == 0 && Character.isWhitespace(c) || i == len - 1 && Character.isWhitespace(c)) {
                return false;
            }
            ++i;
        }
        return s.indexOf(LINE_SEPARATOR) < 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void convert(BufferedReader stream, Entity entity, char endOfColumn, boolean hasHeaderRow, boolean ignoreHeader, String endOfLine) {
        try {
            CSVParser parser = new CSVParser(stream, endOfLine, endOfColumn);
            Vector columns = new Vector();
            Vector emptyStrings = new Vector();
            Vector headerColumns = null;
            Connection connection = entity.getBookmark().getConnection();
            SQLVirtualResultSet rs = new SQLVirtualResultSet(entity, 1003, 1008);
            if (hasHeaderRow) {
                parser.parse(columns, emptyStrings);
                if (!ignoreHeader) {
                    headerColumns = (Vector)columns.clone();
                }
            }
            columns.clear();
            this.numGoodInserts = 0L;
            this.numBadInserts = 0L;
            if (rs.isInsertCapable()) {
                try {
                    while (parser.parse(columns, emptyStrings) == 0) {
                        if (rs.insertRow(columns, headerColumns, emptyStrings)) {
                            ++this.numGoodInserts;
                        } else {
                            ++this.numBadInserts;
                        }
                        columns.clear();
                    }
                    Object var13_19 = null;
                    rs.close();
                    return;
                }
                catch (Throwable throwable) {
                    Object var13_18 = null;
                    rs.close();
                    throw throwable;
                }
            }
            String[] columnNames = rs.getColumnNames();
            if (headerColumns != null) {
                Vector<String> matchedColumnNames = new Vector<String>();
                int i = 0;
                while (i < columnNames.length) {
                    if (headerColumns.contains(columnNames[i])) {
                        matchedColumnNames.add(columnNames[i]);
                    }
                    ++i;
                }
                columnNames = matchedColumnNames.toArray(new String[matchedColumnNames.size()]);
            }
            rs.close();
            StringMatrix columnsMatrix = new StringMatrix();
            Statement statement = connection.createStatement();
            while (parser.parse(columns, emptyStrings) == 0) {
                Object var17_25;
                columnsMatrix.clearValues();
                int i = 0;
                while (i < columnNames.length) {
                    if (columnNames[i].length() > 0 || ((Boolean)emptyStrings.get(i)).booleanValue()) {
                        columnsMatrix.addHeader(columnNames[i]);
                    }
                    ++i;
                }
                i = 0;
                while (i < columnNames.length) {
                    if (columnNames[i].length() > 0 || ((Boolean)emptyStrings.get(i)).booleanValue()) {
                        columnsMatrix.add((String)columns.get(i), 0);
                    }
                    ++i;
                }
                columns.clear();
                String query = SQLInstructionBuilder.buildInsert((Entity)entity, (StringMatrix)columnsMatrix);
                try {
                    statement.execute(query);
                    var17_25 = null;
                }
                catch (Throwable throwable) {
                    var17_25 = null;
                    statement.close();
                    throw throwable;
                }
                statement.close();
            }
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        catch (NotConnectedException e) {
            e.printStackTrace();
            return;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public long getNumBadInserts() {
        return this.numBadInserts;
    }

    public long getNumGoodInserts() {
        return this.numGoodInserts;
    }
}

