/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.wizards;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.model.Column;
import com.quantum.model.Entity;
import com.quantum.sql.FilterSort;
import com.quantum.sql.SQLResultSetResults;
import com.quantum.ui.dialog.ConnectionUtil;
import com.quantum.ui.dialog.SQLExceptionDialog;
import com.quantum.util.connection.NotConnectedException;
import com.quantum.wizards.CommonWizardUI;
import com.quantum.wizards.SQLPage;
import java.sql.SQLException;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SortFilterPage
extends WizardPage
implements SQLPage {
    private SQLResultSetResults.Row row;
    private ConnectionUtil connectionUtil = new ConnectionUtil();
    CommonWizardUI comUI;
    SortFilterTableValues[] sortFilterValues;
    TableViewer tableViewer = null;
    static Image imgCheck = null;
    static Image imgUncheck = null;
    String[] columnNames;
    Text query;
    FilterSort filterSort = new FilterSort();
    private SQLResultSetResults results;
    String[] colNames = new String[]{"Where", "Operator", "Values", "Is String", "Order By", "Sorter"};
    String[] oper = new String[]{"=", "<>", "<", ">", "IS", "ISNOT", "LIKE"};
    String[] order = new String[]{"", "ASC", "DESC"};

    static {
        imgCheck = ImageStore.getImage("checked");
        imgUncheck = ImageStore.getImage("unchecked");
    }

    public SortFilterPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.getString("com.quantum.view.tableview.TableViewActionGroup.filterSortTitle"));
        this.setDescription(Messages.getString("com.quantum.view.tableview.TableViewActionGroup.filterSortDesc"));
    }

    public void init(SQLResultSetResults results, SQLResultSetResults.Row row) {
        this.results = results;
        this.row = row;
    }

    public void createControl(Composite parent) {
        System.out.println("page create control");
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1810));
        this.comUI = new CommonWizardUI();
        this.columnNames = this.results.getColumnNames();
        int nLen = this.columnNames.length;
        this.sortFilterValues = new SortFilterTableValues[nLen];
        int nCtr = 0;
        while (nCtr < nLen) {
            this.sortFilterValues[nCtr] = new SortFilterTableValues();
            this.sortFilterValues[nCtr].setColNames(this.columnNames[nCtr]);
            Object data = this.row == null ? null : this.row.get(nCtr + 1);
            this.sortFilterValues[nCtr].setValues(data == null ? "" : data.toString());
            ++nCtr;
        }
        this.createTable(container);
        this.query = new Text(container, 578);
        this.query.setLayoutData((Object)this.comUI.createGridData(1, 10, 4));
        this.query.setVisible(true);
        this.setControl((Control)container);
        this.setPageComplete(true);
    }

    public void updateQuery() {
        this.query.setVisible(true);
        this.filterSort.clearFilters();
        int nLen = this.columnNames.length;
        int nCtr = 0;
        while (nCtr < nLen) {
            if (this.sortFilterValues[nCtr].isWhere()) {
                this.filterSort.addFilter(this.columnNames[nCtr], this.sortFilterValues[nCtr].getOperators(), this.sortFilterValues[nCtr].getValues(), this.sortFilterValues[nCtr].isString());
            }
            if (this.sortFilterValues[nCtr].isOrderBy()) {
                this.filterSort.addSort(this.columnNames[nCtr], this.sortFilterValues[nCtr].getSorter());
            } else {
                this.filterSort.removeSort(this.columnNames[nCtr]);
            }
            ++nCtr;
        }
        this.query.setText(this.filterSort.toString());
    }

    public boolean performFinish() {
        this.results.setFilterSort(this.filterSort);
        try {
            this.results.refresh(this.connectionUtil.connect(this.results.getConnectable(), this.getShell()));
            return true;
        }
        catch (SQLException e) {
            SQLExceptionDialog.openException(this.getShell(), this.results.getConnectable(), e);
            return false;
        }
    }

    private void updateView() {
        this.tableViewer.update((Object[])this.sortFilterValues, null);
    }

    protected Column getColumn(Entity entity, String columnName) {
        try {
            return entity == null ? null : entity.getColumn(columnName);
        }
        catch (NotConnectedException notConnectedException) {
            return null;
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    private void createTable(Composite composite) {
        System.out.println("Creating table...");
        Table table = this.comUI.createTablePage(composite);
        this.comUI.createTableColumn(table, this.colNames[0], 16384, 0, 150);
        this.comUI.createTableColumn(table, this.colNames[1], 0x1000000, 1, 70);
        this.comUI.createTableColumn(table, this.colNames[2], 16384, 2, 150);
        this.comUI.createTableColumn(table, this.colNames[3], 16384, 3, 70);
        this.comUI.createTableColumn(table, this.colNames[4], 16384, 4, 150);
        this.comUI.createTableColumn(table, this.colNames[5], 0x1000000, 5, 70);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setColumnProperties(this.colNames);
        CellEditor[] editor = new CellEditor[this.colNames.length];
        editor[0] = new CheckboxCellEditor((Composite)table, 0);
        editor[1] = new ComboBoxCellEditor((Composite)table, this.oper, 8);
        editor[2] = new TextCellEditor((Composite)table);
        editor[3] = new CheckboxCellEditor((Composite)table, 0);
        editor[4] = new CheckboxCellEditor((Composite)table, 0);
        editor[5] = new ComboBoxCellEditor((Composite)table, this.order, 8);
        this.tableViewer.setCellEditors(editor);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProviderImpl());
        this.tableViewer.setContentProvider((IContentProvider)new ContentProviderImpl());
        this.tableViewer.setCellModifier((ICellModifier)new CellModifierImpl());
        this.tableViewer.setInput((Object)this.sortFilterValues);
    }

    class SortFilterTableValues {
        private String colNames = null;
        private boolean isWhere = false;
        private String operators = "";
        private String values = null;
        private boolean isString = false;
        private boolean isOrderBy = false;
        private String sorter = "";

        SortFilterTableValues() {
        }

        public boolean isOrderBy() {
            return this.isOrderBy;
        }

        public void setOrderBy(boolean isOrderBy) {
            this.isOrderBy = isOrderBy;
        }

        public boolean isString() {
            return this.isString;
        }

        public void setString(boolean isString) {
            this.isString = isString;
        }

        public boolean isWhere() {
            return this.isWhere;
        }

        public void setWhere(boolean isWhere) {
            this.isWhere = isWhere;
        }

        public String getOperators() {
            return this.operators;
        }

        public void setOperators(String operators) {
            this.operators = operators;
        }

        public String getSorter() {
            return this.sorter;
        }

        public void setSorter(String sorter) {
            this.sorter = sorter;
        }

        public String getValues() {
            return this.values;
        }

        public void setValues(String values) {
            this.values = values;
        }

        public String getColNames() {
            return this.colNames;
        }

        public void setColNames(String colNames) {
            this.colNames = colNames;
        }
    }

    class LabelProviderImpl
    implements ITableLabelProvider {
        LabelProviderImpl() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ((SortFilterTableValues)element).isWhere() ? imgCheck : imgUncheck;
            }
            if (columnIndex == 3) {
                return ((SortFilterTableValues)element).isString() ? imgCheck : imgUncheck;
            }
            if (columnIndex == 4) {
                return ((SortFilterTableValues)element).isOrderBy() ? imgCheck : imgUncheck;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String sReturn = "";
            SortFilterTableValues sortFilterRow = (SortFilterTableValues)element;
            switch (columnIndex) {
                case 0: {
                    sReturn = sortFilterRow.getColNames();
                    break;
                }
                case 1: {
                    sReturn = sortFilterRow.getOperators();
                    break;
                }
                case 2: {
                    sReturn = sortFilterRow.getValues();
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    sReturn = sortFilterRow.getColNames();
                    break;
                }
                case 5: {
                    sReturn = sortFilterRow.getSorter();
                    break;
                }
            }
            return sReturn;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class ContentProviderImpl
    implements IStructuredContentProvider {
        ContentProviderImpl() {
        }

        public Object[] getElements(Object inputElement) {
            return SortFilterPage.this.sortFilterValues;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class CellModifierImpl
    implements ICellModifier {
        CellModifierImpl() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            System.out.println("getValue called");
            int colIndx = SortFilterPage.this.comUI.getColumnNamesAsList(SortFilterPage.this.colNames).indexOf(property);
            System.out.println("colIndx : " + colIndx);
            Object rResult = null;
            SortFilterTableValues sortFilterVal = (SortFilterTableValues)element;
            switch (colIndx) {
                case 0: {
                    rResult = new Boolean(sortFilterVal.isWhere());
                    break;
                }
                case 1: {
                    String sTemp = sortFilterVal.getOperators();
                    int nIndex = SortFilterPage.this.comUI.getColumnNamesAsList(SortFilterPage.this.oper).indexOf(sTemp);
                    rResult = new Integer(nIndex);
                    break;
                }
                case 2: {
                    rResult = sortFilterVal.getValues();
                    break;
                }
                case 3: {
                    rResult = new Boolean(sortFilterVal.isString());
                    break;
                }
                case 4: {
                    rResult = new Boolean(sortFilterVal.isOrderBy());
                    break;
                }
                case 5: {
                    String sTemp2 = sortFilterVal.getSorter();
                    int nIndx = SortFilterPage.this.comUI.getColumnNamesAsList(SortFilterPage.this.order).indexOf(sTemp2);
                    rResult = new Integer(nIndx);
                    break;
                }
                default: {
                    rResult = "";
                }
            }
            return rResult;
        }

        public void modify(Object element, String property, Object value) {
            int colIndx = SortFilterPage.this.comUI.getColumnNamesAsList(SortFilterPage.this.colNames).indexOf(property);
            TableItem item = (TableItem)element;
            SortFilterTableValues sortFilterVal = (SortFilterTableValues)item.getData();
            switch (colIndx) {
                case 0: {
                    sortFilterVal.setWhere((Boolean)value);
                    break;
                }
                case 1: {
                    int nIdx = (Integer)value;
                    if (nIdx != -1) {
                        sortFilterVal.setOperators(SortFilterPage.this.oper[nIdx]);
                        break;
                    }
                    sortFilterVal.setOperators("");
                    break;
                }
                case 2: {
                    sortFilterVal.setValues(value.toString());
                    break;
                }
                case 3: {
                    sortFilterVal.setString((Boolean)value);
                    break;
                }
                case 4: {
                    sortFilterVal.setOrderBy((Boolean)value);
                    break;
                }
                case 5: {
                    int nId = (Integer)value;
                    if (nId != -1) {
                        sortFilterVal.setSorter(SortFilterPage.this.order[nId]);
                        break;
                    }
                    sortFilterVal.setSorter("");
                    break;
                }
            }
            SortFilterPage.this.updateView();
            SortFilterPage.this.updateQuery();
        }
    }
}

