/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.wizards;

import com.quantum.Messages;
import com.quantum.model.Bookmark;
import com.quantum.model.BookmarkCollection;
import com.quantum.model.JDBCDriver;
import com.quantum.view.JDBCDriverTableViewer;
import com.quantum.wizards.AddDriverWizard;
import com.quantum.wizards.PropertyChangeWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class JDBCDriverSelectionWizardPage
extends PropertyChangeWizardPage
implements ISelectionChangedListener {
    private JDBCDriverTableViewer tableViewer;
    private JDBCDriver driver = null;
    static /* synthetic */ Class class$0;

    public JDBCDriverSelectionWizardPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.getString(((Object)((Object)this)).getClass(), "title"));
        this.setDescription(Messages.getString(((Object)((Object)this)).getClass(), "description"));
    }

    public void createControl(Composite parent) {
        this.setPageComplete(false);
        Composite container = this.createBasicContainer(parent, 1);
        GridLayout layout = new GridLayout(1, false);
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        this.tableViewer = new JDBCDriverTableViewer(container);
        GridData data = new GridData(1808);
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        this.tableViewer.getControl().setLayoutData((Object)data);
        this.tableViewer.addSelectionChangedListener(this);
        Button newDriver = new Button(container, 8);
        newDriver.setText(Messages.getString(((Object)((Object)this)).getClass(), "addDriver"));
        newDriver.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddDriverWizard wizard = new AddDriverWizard();
                WizardDialog dialog = new WizardDialog(JDBCDriverSelectionWizardPage.this.getShell(), (IWizard)wizard);
                dialog.open();
            }
        });
        Button deleteDriver = new Button(container, 8);
        deleteDriver.setText(Messages.getString(((Object)((Object)this)).getClass(), "deleteDriver"));
        deleteDriver.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JDBCDriverSelectionWizardPage.this.driver == null) {
                    MessageDialog.openInformation((Shell)JDBCDriverSelectionWizardPage.this.getShell(), (String)Messages.getString(((Object)((Object)this)).getClass(), "nothingToDeleteTitle"), (String)Messages.getString(((Object)((Object)this)).getClass(), "nothingToDeleteMsg"));
                } else {
                    Bookmark[] bookmarks = BookmarkCollection.getInstance().getBookmarksUsingDriver(JDBCDriverSelectionWizardPage.this.driver);
                    if (bookmarks.length > 0) {
                        String bookmarksMessage = "";
                        int i = 0;
                        while (i < bookmarks.length) {
                            bookmarksMessage = String.valueOf(bookmarksMessage) + "\n" + bookmarks[i].getName();
                            ++i;
                        }
                        MessageDialog.openInformation((Shell)JDBCDriverSelectionWizardPage.this.getShell(), (String)Messages.getString(((Object)((Object)this)).getClass(), "driverUsedTitle"), (String)(String.valueOf(Messages.getString(((Object)((Object)this)).getClass(), "driverUsedMsg")) + bookmarksMessage));
                    } else {
                        MessageDialog confirmDialog = new MessageDialog(JDBCDriverSelectionWizardPage.this.getShell(), Messages.getString(((Object)((Object)this)).getClass(), "confirmDeleteTitle"), null, String.valueOf(Messages.getString(((Object)((Object)this)).getClass(), "confirmDeleteMsg")) + JDBCDriverSelectionWizardPage.this.driver.getDisplayName(), 3, new String[]{Messages.getString(((Object)((Object)this)).getClass(), "confirmDeleteButton"), Messages.getString(((Object)((Object)this)).getClass(), "cancelDeleteButton")}, 1);
                        if (confirmDialog.open() == 0 && !BookmarkCollection.getInstance().removeDriver(JDBCDriverSelectionWizardPage.this.driver)) {
                            Shell shell = JDBCDriverSelectionWizardPage.this.getShell();
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = class$0 = Class.forName("com.quantum.view.driver.DeleteDriverAction");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            String string = Messages.getString(clazz, "failed");
                            Class<?> clazz2 = class$0;
                            if (clazz2 == null) {
                                try {
                                    clazz2 = class$0 = Class.forName("com.quantum.view.driver.DeleteDriverAction");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            MessageDialog.openWarning((Shell)shell, (String)string, (String)Messages.getString(clazz2, "cant"));
                        }
                    }
                }
            }
        });
        data = new GridData(34);
        newDriver.setLayoutData((Object)data);
        this.setControl((Control)container);
    }

    private Composite createBasicContainer(Composite parent, int numberOfColumns) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = numberOfColumns;
        layout.verticalSpacing = 9;
        GridData fullHorizontal = new GridData(1808);
        container.setLayoutData((Object)fullHorizontal);
        return container;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        this.setPageComplete(!selection.isEmpty());
        if (!selection.isEmpty()) {
            this.setDriver((JDBCDriver)selection.getFirstElement());
        }
    }

    public JDBCDriver getDriver() {
        return this.driver;
    }

    public void setDriver(JDBCDriver driver) {
        if (this.driver != driver) {
            JDBCDriver original = this.driver;
            this.driver = driver;
            this.firePropertyChange("driver", original, driver);
        }
    }

    public void dispose() {
        this.tableViewer.dispose();
        super.dispose();
    }
}

