/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.wizards;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.adapters.DatabaseAdapter;
import com.quantum.model.Bookmark;
import com.quantum.util.StringMatrix;
import com.quantum.wizards.BaseSQLPage;
import com.quantum.wizards.CommonWizardUI;
import com.quantum.wizards.SQLPage;
import java.util.ArrayList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class InsertRowPage
extends BaseSQLPage
implements SQLPage {
    String[] columnNames;
    String[] colNames;
    Text query;
    InsertRowTableValues[] insertTable = null;
    CommonWizardUI comUI;
    TableViewer tableViewer = null;
    int numColumns = 0;
    static Image imgCheck = null;
    static Image imgUncheck = null;

    static {
        imgCheck = ImageStore.getImage("checked");
        imgUncheck = ImageStore.getImage("unchecked");
    }

    public InsertRowPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.getString("TableView.InsertRowTitle"));
        this.setDescription(Messages.getString("TableView.InsertRowDesc"));
    }

    public void createControl(Composite parent) {
        System.out.println("page create control");
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1810));
        this.comUI = new CommonWizardUI();
        this.columnNames = this.results.getColumnNames();
        int nLen = this.columnNames.length;
        this.insertTable = new InsertRowTableValues[nLen];
        int nCtr = 0;
        while (nCtr < nLen) {
            this.insertTable[nCtr] = new InsertRowTableValues();
            this.insertTable[nCtr].setColNames(this.columnNames[nCtr]);
            this.insertTable[nCtr].setValues("");
            ++nCtr;
        }
        this.createTable(container);
        this.query = new Text(container, 586);
        this.query.setLayoutData((Object)this.comUI.createGridData(1, 10, 4));
        this.query.setVisible(false);
        this.setControl((Control)container);
        this.setPageComplete(true);
    }

    public void updateQuery() {
        System.out.println("Updating query");
        this.query.setVisible(true);
        StringMatrix columns = new StringMatrix();
        ArrayList<Boolean> noQuote = new ArrayList<Boolean>();
        int i = 0;
        while (i < this.columnNames.length) {
            if (!this.insertTable[i].isDefaultVal()) {
                columns.addHeader(this.insertTable[i].getColNames());
                columns.add(this.insertTable[i].getValues(), 0);
                noQuote.add(new Boolean(this.insertTable[i].isNoQuote()));
            }
            ++i;
        }
        Bookmark bookmark = (Bookmark)this.results.getConnectable();
        DatabaseAdapter adapter = bookmark.getAdapter();
        this.query.setText(adapter.buildInsert(this.results.getEntity(), columns, noQuote));
    }

    protected String getQueryText() {
        return this.query.getText();
    }

    private void createTable(Composite composite) {
        System.out.println("Creating table...");
        Table table = this.comUI.createTablePage(composite);
        this.colNames = new String[]{Messages.getString("InsertRowPage.ColumnName"), Messages.getString("InsertRowPage.DefaultValue"), Messages.getString("InsertRowPage.NoQuote"), Messages.getString("InsertRowPage.Value")};
        this.comUI.createTableColumn(table, this.colNames[0], 16384, 0, 200);
        this.comUI.createTableColumn(table, this.colNames[1], 0x1000000, 1, 40);
        this.comUI.createTableColumn(table, this.colNames[2], 0x1000000, 2, 40);
        this.comUI.createTableColumn(table, this.colNames[3], 16384, 3, 500);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setColumnProperties(this.colNames);
        CellEditor[] editor = new CellEditor[this.colNames.length];
        TextCellEditor txtEditorField = new TextCellEditor((Composite)table);
        txtEditorField.getControl().setEnabled(false);
        editor[0] = txtEditorField;
        TextCellEditor txtEditorValues = new TextCellEditor((Composite)table);
        editor[1] = new CheckboxCellEditor((Composite)table, 0);
        editor[2] = new CheckboxCellEditor((Composite)table, 0);
        editor[3] = txtEditorValues;
        this.tableViewer.setCellEditors(editor);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProviderImpl());
        this.tableViewer.setContentProvider((IContentProvider)new ContentProviderImpl());
        this.tableViewer.setCellModifier((ICellModifier)new CellModifierImpl());
        this.tableViewer.setInput((Object)this.insertTable);
    }

    private void updateView() {
        this.tableViewer.update((Object[])this.insertTable, null);
    }

    class InsertRowTableValues {
        private String colNames = null;
        private String values = null;
        private boolean defaultVal = false;
        private boolean noQuote = false;

        public boolean isNoQuote() {
            return this.noQuote;
        }

        public void setNoQuote(boolean noQuote) {
            this.noQuote = noQuote;
        }

        public String getColNames() {
            return this.colNames;
        }

        public void setColNames(String colNames) {
            this.colNames = colNames;
        }

        public String getValues() {
            return this.values;
        }

        public void setValues(String values) {
            this.values = values;
        }

        public boolean isDefaultVal() {
            return this.defaultVal;
        }

        public void setDefaultVal(boolean defaultVal) {
            this.defaultVal = defaultVal;
        }
    }

    class LabelProviderImpl
    implements ITableLabelProvider {
        LabelProviderImpl() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 1) {
                return ((InsertRowTableValues)element).isDefaultVal() ? imgCheck : imgUncheck;
            }
            if (columnIndex == 2) {
                return ((InsertRowTableValues)element).isNoQuote() ? imgCheck : imgUncheck;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String sReturn = "";
            InsertRowTableValues insertRow = (InsertRowTableValues)element;
            switch (columnIndex) {
                case 0: {
                    sReturn = insertRow.getColNames();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    sReturn = insertRow.getValues();
                    break;
                }
            }
            return sReturn;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class ContentProviderImpl
    implements IStructuredContentProvider {
        ContentProviderImpl() {
        }

        public Object[] getElements(Object inputElement) {
            return InsertRowPage.this.insertTable;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class CellModifierImpl
    implements ICellModifier {
        CellModifierImpl() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            System.out.println("getValue called");
            int colIndx = InsertRowPage.this.comUI.getColumnNamesAsList(InsertRowPage.this.colNames).indexOf(property);
            System.out.println("colIndx : " + colIndx);
            Object rResult = null;
            InsertRowTableValues insertVal = (InsertRowTableValues)element;
            switch (colIndx) {
                case 0: {
                    rResult = insertVal.getColNames();
                    break;
                }
                case 1: {
                    rResult = new Boolean(insertVal.isDefaultVal());
                    break;
                }
                case 2: {
                    rResult = new Boolean(insertVal.isNoQuote());
                    break;
                }
                case 3: {
                    rResult = insertVal.getValues();
                    break;
                }
                default: {
                    rResult = "";
                }
            }
            return rResult;
        }

        public void modify(Object element, String property, Object value) {
            int colIndx = InsertRowPage.this.comUI.getColumnNamesAsList(InsertRowPage.this.colNames).indexOf(property);
            TableItem item = (TableItem)element;
            InsertRowTableValues insertVal = (InsertRowTableValues)item.getData();
            switch (colIndx) {
                case 0: {
                    break;
                }
                case 1: {
                    insertVal.setDefaultVal((Boolean)value);
                    break;
                }
                case 2: {
                    insertVal.setNoQuote((Boolean)value);
                    break;
                }
                case 3: {
                    insertVal.setValues(value.toString());
                    break;
                }
            }
            InsertRowPage.this.updateView();
            InsertRowPage.this.updateQuery();
        }
    }
}

