/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.wizards;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.model.Bookmark;
import com.quantum.model.BookmarkCollection;
import com.quantum.model.xml.ModelToXMLConverter;
import com.quantum.ui.dialog.ExceptionDisplayDialog;
import com.quantum.util.xml.XMLHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;

public class ExportBookmarkWizardPage
extends WizardPage {
    private CheckboxTreeViewer treeViewer;
    private Text fileNameText;
    private boolean sourceIsSelected = false;
    private boolean destinationIsSelected = false;

    protected ExportBookmarkWizardPage() {
        super("page1");
        this.setTitle(Messages.getString(((Object)((Object)this)).getClass(), "title"));
    }

    public void createControl(Composite pageContainer) {
        this.sourceIsSelected = false;
        this.destinationIsSelected = false;
        Composite composite = new Composite(pageContainer, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.treeViewer = new CheckboxTreeViewer(composite, 2848);
        this.treeViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.treeViewer.setInput((Object)BookmarkCollection.getInstance());
        this.selectAll();
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ExportBookmarkWizardPage.this.setSourceIsSelected(ExportBookmarkWizardPage.this.treeViewer.getCheckedElements().length > 0);
            }
        });
        GridData data = new GridData();
        data.horizontalAlignment = 256;
        data.verticalAlignment = 2;
        data.grabExcessHorizontalSpace = true;
        data.heightHint = 200;
        data.widthHint = 400;
        this.treeViewer.getControl().setLayoutData((Object)data);
        Composite buttons = new Composite(composite, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(32));
        Button selectAll = new Button(buttons, 0);
        selectAll.setText(Messages.getString(((Object)((Object)this)).getClass(), "selectAll"));
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportBookmarkWizardPage.this.selectAll();
            }
        });
        Button deselectAll = new Button(buttons, 0);
        deselectAll.setText(Messages.getString(((Object)((Object)this)).getClass(), "deselectAll"));
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportBookmarkWizardPage.this.deselectAll();
            }
        });
        this.createDestinationArea(composite);
        this.setControl((Control)composite);
    }

    private void createDestinationArea(Composite composite) {
        Composite fileArea = new Composite(composite, 0);
        fileArea.setLayout((Layout)new GridLayout(3, false));
        fileArea.setLayoutData((Object)new GridData(272));
        Label label = new Label(fileArea, 0);
        label.setText("File name:");
        this.fileNameText = new Text(fileArea, 2048);
        GridData data = new GridData();
        data.horizontalAlignment = 256;
        data.widthHint = 300;
        this.fileNameText.setLayoutData((Object)data);
        this.fileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String text = ((Text)event.getSource()).getText();
                ExportBookmarkWizardPage.this.setDestinationIsSelected(text != null && text.trim().length() > 0);
            }
        });
        Button button = new Button(fileArea, 0);
        button.setText("Browse");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportBookmarkWizardPage.this.promptForFile();
            }
        });
    }

    private void setSourceIsSelected(boolean selected) {
        this.sourceIsSelected = selected;
        this.setPageComplete(selected & this.destinationIsSelected);
    }

    private void setDestinationIsSelected(boolean selected) {
        this.destinationIsSelected = selected;
        this.setPageComplete(selected & this.sourceIsSelected);
    }

    protected void promptForFile() {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setFilterExtensions(new String[]{"xml"});
        dialog.setFilterNames(new String[]{"XML Files (*.xml)"});
        String filename = dialog.open();
        if (filename != null) {
            this.fileNameText.setText(filename);
        }
    }

    protected void deselectAll() {
        this.treeViewer.setCheckedElements(new Object[0]);
        this.setSourceIsSelected(false);
    }

    protected void selectAll() {
        Object[] bookmarks = BookmarkCollection.getInstance().getBookmarks();
        this.treeViewer.setCheckedElements(bookmarks);
        this.setSourceIsSelected(bookmarks.length > 0);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean finish() {
        String fileName = this.fileNameText.getText();
        File file = new File(fileName);
        if (!file.exists()) {
            file.getParentFile().exists();
        }
        try {
            FileWriter writer;
            int length;
            Object[] bookmarks = this.treeViewer.getCheckedElements();
            Document document = XMLHelper.createEmptyDocument();
            ModelToXMLConverter.getInstance().createRoot(document);
            int i = 0;
            int n = length = bookmarks == null ? 0 : bookmarks.length;
            while (true) {
                if (i >= length) {
                    writer = new FileWriter(file);
                    try {
                        XMLHelper.write(writer, document);
                        break;
                    }
                    catch (Throwable throwable) {
                        Object var6_10 = null;
                        writer.close();
                        throw throwable;
                    }
                }
                ModelToXMLConverter.getInstance().convert(document.getDocumentElement(), (Bookmark)bookmarks[i]);
                ++i;
            }
            {
                Object var6_11 = null;
                writer.close();
                return true;
            }
        }
        catch (IOException e) {
            ExceptionDisplayDialog.openError(this.getShell(), Messages.getString(((Object)((Object)this)).getClass(), "error.IOException.title"), Messages.getString(((Object)((Object)this)).getClass(), "error.IOException.message", new Object[]{fileName}), e);
            return true;
        }
        catch (ParserConfigurationException e) {
            ExceptionDisplayDialog.openError(this.getShell(), Messages.getString(((Object)((Object)this)).getClass(), "error.IOException.title"), Messages.getString(((Object)((Object)this)).getClass(), "error.IOException.message", new Object[]{fileName}), e);
        }
        return true;
    }

    public class ContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof BookmarkCollection) {
                return ((BookmarkCollection)parentElement).getBookmarks();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof Bookmark) {
                return BookmarkCollection.getInstance();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof BookmarkCollection) {
                return ((BookmarkCollection)element).getBookmarks().length > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class LabelProvider
    implements ILabelProvider {
        public Image getImage(Object element) {
            if (element instanceof Bookmark) {
                return ImageStore.getImage("bookmarks");
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof Bookmark) {
                return ((Bookmark)element).getName();
            }
            return element.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

