/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.wizards;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.model.Bookmark;
import com.quantum.model.BookmarkCollection;
import com.quantum.model.JDBCDriver;
import com.quantum.model.Schema;
import com.quantum.wizards.BookmarkConnectionWizardPage;
import com.quantum.wizards.BookmarkNameWizardPage;
import com.quantum.wizards.JDBCDriverSelectionWizardPage;
import com.quantum.wizards.SchemaSelectionWizardPage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class BookmarkWizard
extends Wizard
implements PropertyChangeListener {
    private JDBCDriverSelectionWizardPage page1;
    private BookmarkConnectionWizardPage page2;
    private BookmarkNameWizardPage page3;
    private SchemaSelectionWizardPage page4;
    private Bookmark bookmark;

    public void init() {
        this.setWindowTitle(Messages.getString("BookmarkWizard.NewBookmark"));
        this.setDefaultPageImageDescriptor(ImageStore.getImageDescriptor("new_bookmark_wizard"));
        this.bookmark = new Bookmark();
    }

    public boolean performFinish() {
        BookmarkCollection.getInstance().addBookmark(this.bookmark);
        return true;
    }

    public void addPages() {
        this.page1 = new JDBCDriverSelectionWizardPage("page1");
        this.page1.addPropertyChangeListener(this);
        this.addPage((IWizardPage)this.page1);
        this.page2 = new BookmarkConnectionWizardPage("page2");
        this.page2.addPropertyChangeListener(this);
        this.addPage((IWizardPage)this.page2);
        this.page3 = new BookmarkNameWizardPage("page3");
        this.page3.addPropertyChangeListener(this);
        this.addPage((IWizardPage)this.page3);
        this.page4 = new SchemaSelectionWizardPage("page4", this.bookmark);
        this.page4.addPropertyChangeListener(this);
        this.addPage((IWizardPage)this.page4);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("driver".equals(event.getPropertyName())) {
            JDBCDriver driver = (JDBCDriver)event.getNewValue();
            this.bookmark.setJDBCDriver(driver);
            this.page2.setDriver(driver);
        } else if ("name".equals(event.getPropertyName())) {
            this.bookmark.setName((String)event.getNewValue());
        } else if ("userid".equals(event.getPropertyName())) {
            this.bookmark.setUsername((String)event.getNewValue());
        } else if ("password".equals(event.getPropertyName())) {
            this.bookmark.setPassword((String)event.getNewValue());
        } else if ("connectionURL".equals(event.getPropertyName())) {
            this.bookmark.setConnect((String)event.getNewValue());
        } else if ("prompt".equals(event.getPropertyName())) {
            this.bookmark.setPromptForPassword(Boolean.TRUE.equals(event.getNewValue()));
        } else if ("schemaRule".equals(event.getPropertyName())) {
            this.bookmark.setSchemaRule((Integer)event.getNewValue());
        } else if ("schemas".equals(event.getPropertyName())) {
            this.bookmark.setSchemaSelections((Schema[])event.getNewValue());
        }
    }

    public void dispose() {
        this.page1.removePropertyChangeListener(this);
        this.page2.removePropertyChangeListener(this);
        this.page3.removePropertyChangeListener(this);
        this.page4.removePropertyChangeListener(this);
        super.dispose();
    }
}

