/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.wizards;

import com.quantum.adapters.DatabaseAdapter;
import com.quantum.model.Bookmark;
import com.quantum.model.Column;
import com.quantum.model.Entity;
import com.quantum.sql.MultiSQLServer;
import com.quantum.sql.SQLResultSetResults;
import com.quantum.sql.SQLResults;
import com.quantum.ui.dialog.ConnectionUtil;
import com.quantum.ui.dialog.SQLExceptionDialog;
import com.quantum.util.connection.NotConnectedException;
import com.quantum.wizards.SQLPage;
import java.sql.SQLException;
import org.eclipse.jface.wizard.WizardPage;

public abstract class BaseSQLPage
extends WizardPage
implements SQLPage {
    protected SQLResultSetResults.Row row;
    protected SQLResultSetResults results;
    private ConnectionUtil connectionUtil = new ConnectionUtil();

    public BaseSQLPage(String pageName) {
        super(pageName);
    }

    public boolean performFinish() {
        Bookmark bookmark = (Bookmark)this.results.getConnectable();
        try {
            bookmark.addQuery(this.getQueryText());
            SQLResults sqlResults = MultiSQLServer.getInstance().execute(bookmark, this.connectionUtil.getConnection(bookmark, this.getShell()), this.getQueryText());
            return sqlResults != null;
        }
        catch (SQLException e) {
            SQLExceptionDialog.openException(this.getShell(), bookmark, e);
            return false;
        }
    }

    protected abstract String getQueryText();

    protected void appendColumn(StringBuffer whereClause, Entity entity, String columnName, DatabaseAdapter adapter, String value) {
        if (adapter != null && entity != null && this.getColumn(entity, columnName) != null) {
            Column column = this.getColumn(entity, columnName);
            whereClause.append(adapter.quote(value, column.getType(), column.getTypeName()));
        } else {
            whereClause.append(value);
        }
    }

    protected Column getColumn(Entity entity, String columnName) {
        try {
            return entity == null ? null : entity.getColumn(columnName);
        }
        catch (NotConnectedException notConnectedException) {
            return null;
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public void init(SQLResultSetResults results, SQLResultSetResults.Row row) {
        this.results = results;
        this.row = row;
    }
}

